/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Set;

public class VaultRegistryRedundancyFeature
implements Redundancy {
    private final Session<?> session;
    private final Redundancy proxy;
    private final VaultRegistry registry;

    public VaultRegistryRedundancyFeature(Session<?> session, Redundancy proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public String getDefault() {
        return this.proxy.getDefault();
    }

    @Override
    public Set<String> getClasses() {
        return this.proxy.getClasses();
    }

    @Override
    public void setClass(Path file, String redundancy) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Redundancy.class, this.proxy).setClass(file, redundancy);
    }

    @Override
    public String getClass(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Redundancy.class, this.proxy).getClass(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryRedundancyFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

