/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.vault.VaultFinderListProgressListener;
import ch.cyberduck.core.vault.VaultFinderListService;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultRegistryListService
implements ListService {
    private static final Logger log = LogManager.getLogger(VaultRegistryListService.class);
    private final VaultRegistry registry;
    private final VaultLookupListener lookup;
    private final Session<?> session;
    private final ListService proxy;
    private boolean autodetect;

    public VaultRegistryListService(Session<?> session, ListService proxy, VaultRegistry registry, VaultLookupListener lookup) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
        this.lookup = lookup;
        this.autodetect = new HostPreferences(session.getHost()).getBoolean("cryptomator.vault.autodetect") && new HostPreferences(session.getHost()).getBoolean("cryptomator.enable");
    }

    @Override
    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            Vault vault = this.registry.find(this.session, directory);
            if (vault.contains(directory)) {
                return vault.getFeature(this.session, ListService.class, this.proxy).list(directory, listener);
            }
            if (this.autodetect) {
                return new VaultFinderListService(this.session, this.proxy, new VaultFinderListProgressListener(this.session, this.lookup, listener)).list(directory, listener);
            }
            return this.proxy.list(directory, listener);
        }
        catch (VaultUnlockCancelException e) {
            log.warn(String.format("Canceled loading vault %s. %s", e.getVault(), e));
            return this.proxy.list(directory, listener);
        }
    }

    public VaultRegistryListService withAutodetect(boolean autodetect) {
        this.autodetect = autodetect && new HostPreferences(this.session.getHost()).getBoolean("cryptomator.enable");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryListService{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

