/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultRegistryFindFeature
implements Find {
    private static final Logger log = LogManager.getLogger(VaultRegistryFindFeature.class);
    private final Session<?> session;
    private final Find proxy;
    private final VaultRegistry registry;
    private final VaultLookupListener lookup;
    private boolean autodetect;

    public VaultRegistryFindFeature(Session<?> session, Find proxy, VaultRegistry registry, VaultLookupListener lookup) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
        this.lookup = lookup;
        this.autodetect = new HostPreferences(session.getHost()).getBoolean("cryptomator.vault.autodetect") && new HostPreferences(session.getHost()).getBoolean("cryptomator.enable");
    }

    @Override
    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        Path directory;
        Path key;
        Vault vault = this.registry.find(this.session, file);
        if (vault.equals(Vault.DISABLED) && this.autodetect && this.proxy.find(key = new Path(directory = file.getParent(), new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.masterkey.filename"), EnumSet.of(AbstractPath.Type.file)), listener)) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Found master key %s", key));
            }
            try {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Found vault %s", directory));
                }
                return this.lookup.load(this.session, directory, new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.masterkey.filename"), new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.config.filename"), new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.pepper").getBytes(StandardCharsets.UTF_8)).getFeature(this.session, Find.class, this.proxy).find(file, listener);
            }
            catch (VaultUnlockCancelException vaultUnlockCancelException) {
                // empty catch block
            }
        }
        return vault.getFeature(this.session, Find.class, this.proxy).find(file, listener);
    }

    public VaultRegistryFindFeature withAutodetect(boolean autodetect) {
        this.autodetect = autodetect && new HostPreferences(this.session.getHost()).getBoolean("cryptomator.enable");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryFindFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

