/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryFileIdProvider
implements FileIdProvider {
    private final Session<?> session;
    private final FileIdProvider proxy;
    private final VaultRegistry registry;

    public VaultRegistryFileIdProvider(Session<?> session, FileIdProvider proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, FileIdProvider.class, this.proxy).getFileId(file, listener);
    }

    @Override
    public void clear() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryFileIdProvider{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

