/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryDirectoryFeature<Reply>
implements Directory<Reply> {
    private final Session<?> session;
    private final Directory<Reply> proxy;
    private final VaultRegistry registry;

    public VaultRegistryDirectoryFeature(Session<?> session, Directory<Reply> proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        return this.registry.find(this.session, folder).getFeature(this.session, Directory.class, this.proxy).mkdir(folder, status);
    }

    @Override
    public boolean isSupported(Path workdir, String name) {
        return this.proxy.isSupported(workdir, name);
    }

    @Override
    public Directory<Reply> withWriter(Write<Reply> writer) {
        return this.proxy.withWriter(writer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryDirectoryFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

