/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;

public class VaultRegistryCopyFeature
implements Copy {
    private final Session<?> session;
    private Session<?> destination;
    private final Copy proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryCopyFeature(Session<?> session, Copy proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.destination = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Path copy(Path source, Path copy, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        if (this.registry.find(this.session, source).equals(Vault.DISABLED)) {
            return this.registry.find(this.session, copy).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).copy(source, copy, status, callback, listener);
        }
        if (this.registry.find(this.session, copy).equals(Vault.DISABLED)) {
            return this.registry.find(this.session, source).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).copy(source, copy, status, callback, listener);
        }
        return this.registry.find(this.session, copy).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).copy(source, copy, status, callback, listener);
    }

    @Override
    public boolean isRecursive(Path source, Path copy) {
        try {
            if (this.registry.find(this.session, source, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, copy, false).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isRecursive(source, copy);
            }
            if (this.registry.find(this.session, copy, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isRecursive(source, copy);
            }
            return this.registry.find(this.session, copy).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isRecursive(source, copy);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isRecursive(source, copy);
        }
    }

    @Override
    public boolean isSupported(Path source, Path copy) {
        try {
            if (this.registry.find(this.session, source, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, copy, false).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isSupported(source, copy);
            }
            if (this.registry.find(this.session, copy, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isSupported(source, copy);
            }
            return this.registry.find(this.session, copy).getFeature(this.session, Copy.class, this.proxy).withTarget(this.destination).isSupported(source, copy);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isSupported(source, copy);
        }
    }

    @Override
    public Copy withTarget(Session<?> session) {
        this.destination = session.withRegistry(this.registry);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryCopyFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

