/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class VaultRegistryBulkFeature<R>
implements Bulk<R> {
    private final Session<?> session;
    private final Bulk<R> proxy;
    private final VaultRegistry registry;

    public VaultRegistryBulkFeature(Session<?> session, Bulk<R> proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public R pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Iterator<Map.Entry<TransferItem, TransferStatus>> iterator = files.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<TransferItem, TransferStatus> file = iterator.next();
            Bulk<R> feature = this.registry.find(this.session, file.getKey().remote).getFeature(this.session, Bulk.class, this.proxy);
            return feature.pre(type, files, callback);
        }
        return null;
    }

    @Override
    public Bulk<R> withDelete(Delete delete) {
        this.proxy.withDelete(delete);
        return this;
    }

    @Override
    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        for (Map.Entry<TransferItem, TransferStatus> file : files.entrySet()) {
            this.registry.find(this.session, file.getKey().remote).getFeature(this.session, Bulk.class, this.proxy).post(type, Collections.singletonMap(file.getKey(), file.getValue()), callback);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryBulkFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

