/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.vault.VaultFoundListCanceledException;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultFinderListProgressListener
extends IndexedListProgressListener {
    private static final Logger log = LogManager.getLogger(VaultFinderListProgressListener.class);
    private final Session<?> session;
    private final VaultLookupListener listener;
    private final ListProgressListener progress;

    public VaultFinderListProgressListener(Session<?> session, VaultLookupListener listener, ListProgressListener progress) {
        this.session = session;
        this.listener = listener;
        this.progress = progress;
    }

    @Override
    public void visit(AttributedList<Path> list, int index, Path file) throws ConnectionCanceledException {
        Path directory = file.getParent();
        if (new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.masterkey.filename").equals(file.getName())) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Found master key %s", file));
            }
            try {
                Vault vault = this.listener.load(this.session, directory, new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.masterkey.filename"), new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.config.filename"), new HostPreferences(this.session.getHost()).getProperty("cryptomator.vault.pepper").getBytes(StandardCharsets.UTF_8));
                if (vault.equals(Vault.DISABLED)) {
                    return;
                }
                throw new VaultFoundListCanceledException(vault, list);
            }
            catch (VaultUnlockCancelException vaultUnlockCancelException) {
                // empty catch block
            }
        }
    }

    @Override
    public void message(String message) {
        this.progress.message(message);
    }
}

