/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.features.Vault;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultFactory
extends Factory<Vault> {
    private static final Logger log = LogManager.getLogger(VaultFactory.class);

    protected VaultFactory() {
        super("factory.vault.class");
    }

    public static Vault get(Path directory, String masterkey, String config, byte[] pepper) {
        return new VaultFactory().create(directory, masterkey, config, pepper);
    }

    private Vault create(Path directory, String masterkey, String config, byte[] pepper) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{directory.getClass(), masterkey.getClass(), config.getClass(), pepper.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s", directory.getClass()));
                return (Vault)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (Vault)constructor.newInstance(directory, masterkey, config, pepper);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return Vault.DISABLED;
        }
    }
}

