/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultFactory;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingVaultLookupListener
implements VaultLookupListener {
    private static final Logger log = LogManager.getLogger(LoadingVaultLookupListener.class);
    private final VaultRegistry registry;
    private final PasswordStore keychain;
    private final PasswordCallback prompt;

    public LoadingVaultLookupListener(VaultRegistry registry, PasswordStore keychain, PasswordCallback prompt) {
        this.registry = registry;
        this.keychain = keychain;
        this.prompt = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vault load(Session session, Path directory, String masterkey, String config, byte[] pepper) throws VaultUnlockCancelException {
        VaultRegistry vaultRegistry = this.registry;
        synchronized (vaultRegistry) {
            if (this.registry.contains(directory)) {
                return this.registry.find(session, directory);
            }
            Vault vault = VaultFactory.get(directory, masterkey, config, pepper);
            if (log.isInfoEnabled()) {
                log.info(String.format("Loading vault %s for session %s", vault, session));
            }
            try {
                this.registry.add(vault.load(session, this.prompt, this.keychain));
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure loading vault %s. %s", vault, e));
                throw new VaultUnlockCancelException(vault, (Throwable)e);
            }
            return vault;
        }
    }
}

