/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.updater;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.SingleThreadController;
import ch.cyberduck.core.updater.DisabledPeriodicUpdater;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodicUpdateCheckerFactory
extends Factory<PeriodicUpdateChecker> {
    private static final Logger log = LogManager.getLogger(PeriodicUpdateCheckerFactory.class);

    public PeriodicUpdateCheckerFactory() {
        super("factory.updater.class");
    }

    public PeriodicUpdateChecker create(Controller controller) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s", controller.getClass()));
                return (PeriodicUpdateChecker)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (PeriodicUpdateChecker)constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledPeriodicUpdater();
        }
    }

    public static PeriodicUpdateChecker get() {
        return PeriodicUpdateCheckerFactory.get(new SingleThreadController());
    }

    public static PeriodicUpdateChecker get(Controller controller) {
        return new PeriodicUpdateCheckerFactory().create(controller);
    }
}

