/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.HostPreferences;

public final class UploadFilterOptions {
    public boolean permissions;
    public boolean acl;
    public boolean timestamp;
    public boolean metadata;
    public boolean temporary;
    public boolean encryption;
    public boolean redundancy;
    public boolean checksum;

    public UploadFilterOptions(Host bookmark) {
        HostPreferences preferences = new HostPreferences(bookmark);
        this.permissions = preferences.getBoolean("queue.upload.permissions.change");
        this.acl = preferences.getBoolean("queue.upload.acl.change");
        this.timestamp = preferences.getBoolean("queue.upload.timestamp.change");
        this.temporary = preferences.getBoolean("queue.upload.file.temporary");
        this.metadata = preferences.getBoolean("queue.upload.file.metadata.change");
        this.encryption = preferences.getBoolean("queue.upload.file.encryption.change");
        this.redundancy = preferences.getBoolean("queue.upload.file.redundancy.change");
        this.checksum = preferences.getBoolean("queue.upload.checksum.calculate");
    }

    public UploadFilterOptions(boolean permissions, boolean timestamp, boolean temporary) {
        this.permissions = permissions;
        this.acl = permissions;
        this.timestamp = timestamp;
        this.temporary = temporary;
    }

    public UploadFilterOptions withPermission(boolean enabled) {
        this.permissions = enabled;
        return this;
    }

    public UploadFilterOptions withAcl(boolean enabled) {
        this.acl = enabled;
        return this;
    }

    public UploadFilterOptions withTimestamp(boolean enabled) {
        this.timestamp = enabled;
        return this;
    }

    public UploadFilterOptions withTemporary(boolean enabled) {
        this.temporary = enabled;
        return this;
    }

    public UploadFilterOptions withMetadata(boolean enabled) {
        this.metadata = enabled;
        return this;
    }

    public UploadFilterOptions withEncryption(boolean enabled) {
        this.encryption = enabled;
        return this;
    }

    public UploadFilterOptions withRedundancy(boolean enabled) {
        this.redundancy = enabled;
        return this;
    }

    public UploadFilterOptions withChecksum(boolean enabled) {
        this.checksum = enabled;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UploadFilterOptions{");
        sb.append("permissions=").append(this.permissions);
        sb.append(", acl=").append(this.acl);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", metadata=").append(this.metadata);
        sb.append(", temporary=").append(this.temporary);
        sb.append(", encryption=").append(this.encryption);
        sb.append(", redundancy=").append(this.redundancy);
        sb.append(", checksum=").append(this.checksum);
        sb.append('}');
        return sb.toString();
    }
}

