/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResumeFilter
extends AbstractUploadFilter {
    private static final Logger log = LogManager.getLogger(ResumeFilter.class);
    private final Upload<?> upload;

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new UploadFilterOptions(session.getHost()));
    }

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        this(symlinkResolver, session, options, session.getFeature(Upload.class));
    }

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, Upload<?> upload) {
        super(symlinkResolver, session, options);
        this.upload = upload;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (super.accept(file, local, parent)) {
            PathAttributes attributes;
            if (local.isFile() && parent.isExists() && this.find.find(file) && (attributes = this.attribute.find(file)).getSize() == local.attributes().getSize()) {
                if (Checksum.NONE != attributes.getChecksum()) {
                    ChecksumCompute compute = ChecksumComputeFactory.get(attributes.getChecksum().algorithm);
                    if (compute.compute(local.getInputStream(), parent).equals(attributes.getChecksum())) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Skip file %s with checksum %s", file, local.attributes().getChecksum()));
                        }
                        return false;
                    }
                    log.warn(String.format("Checksum mismatch for %s and %s", file, local));
                } else {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with remote size %d", file, attributes.getSize()));
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress);
        if (file.isFile() && status.isExists()) {
            Write.Append append = this.upload.append(file, status);
            if (append.append && append.size < status.getLength()) {
                status.withRename((Path)null).withDisplayname((Path)null).setAppend(true);
                status.setLength(status.getLength() - append.size);
                status.setOffset(append.size);
            }
        }
        return status;
    }
}

