/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.DefaultComparePathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompareFilter
extends AbstractUploadFilter {
    private static final Logger log = LogManager.getLogger(CompareFilter.class);
    private final ProgressListener listener;
    private final DefaultComparePathFilter comparisonService;

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, ProgressListener listener) {
        this(symlinkResolver, session, new UploadFilterOptions(session.getHost()), listener);
    }

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, ProgressListener listener) {
        this(symlinkResolver, session, options, listener, new DefaultComparePathFilter(session, session.getHost().getTimezone()));
    }

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, ProgressListener listener, DefaultComparePathFilter comparisonService) {
        super(symlinkResolver, session, options);
        this.listener = listener;
        this.comparisonService = comparisonService;
    }

    @Override
    public AbstractUploadFilter withFinder(Find finder) {
        this.comparisonService.withFinder(finder);
        return super.withFinder(finder);
    }

    @Override
    public AbstractUploadFilter withAttributes(AttributesFinder attributes) {
        this.comparisonService.withAttributes(attributes);
        return super.withAttributes(attributes);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (super.accept(file, local, parent)) {
            Comparison comparison = this.comparisonService.compare(file, local, this.listener);
            switch (comparison) {
                case local: {
                    return true;
                }
                case equal: {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
                case remote: {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
            }
            log.warn(String.format("Invalid comparison result %s", new Object[]{comparison}));
        }
        return false;
    }
}

