/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LocalNotfoundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.ui.browser.SearchFilterFactory;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractUploadFilter
implements TransferPathFilter {
    private static final Logger log = LogManager.getLogger(AbstractUploadFilter.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final Session<?> session;
    private final SymlinkResolver<Local> symlinkResolver;
    private final Filter<Path> hidden = SearchFilterFactory.HIDDEN_FILTER;
    protected Find find;
    protected AttributesFinder attribute;
    protected UploadFilterOptions options;

    public AbstractUploadFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        this.symlinkResolver = symlinkResolver;
        this.session = session;
        this.options = options;
        this.find = session.getFeature(Find.class);
        this.attribute = session.getFeature(AttributesFinder.class);
    }

    @Override
    public AbstractUploadFilter withFinder(Find finder) {
        this.find = finder;
        return this;
    }

    @Override
    public AbstractUploadFilter withAttributes(AttributesFinder attributes) {
        this.attribute = attributes;
        return this;
    }

    public AbstractUploadFilter withOptions(UploadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (!local.exists()) {
            throw new LocalNotfoundException(local.getAbsolute());
        }
        return true;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        Object feature;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Prepare %s", file));
        }
        TransferStatus status = new TransferStatus().hidden(!this.hidden.accept(file)).withLockId(parent.getLockId());
        if (parent.isExists()) {
            if (this.find.find(file)) {
                status.setExists(true);
                PathAttributes attributes = this.attribute.find(file);
                status.setRemote(attributes);
            } else {
                if (file.getType().contains((Object)AbstractPath.Type.file) && this.find.find(new Path(file.getAbsolute(), EnumSet.of(AbstractPath.Type.directory)))) {
                    throw new AccessDeniedException(String.format("Cannot replace folder %s with file %s", file.getAbsolute(), local.getName()));
                }
                if (file.getType().contains((Object)AbstractPath.Type.directory) && this.find.find(new Path(file.getAbsolute(), EnumSet.of(AbstractPath.Type.file)))) {
                    throw new AccessDeniedException(String.format("Cannot replace file %s with folder %s", file.getAbsolute(), local.getName()));
                }
            }
        }
        if (file.isFile()) {
            if (local.isSymbolicLink()) {
                if (!this.symlinkResolver.resolve(local)) {
                    Local target = local.getSymlinkTarget();
                    status.setLength(target.attributes().getSize());
                }
            } else {
                status.setLength(local.attributes().getSize());
            }
            if (this.options.temporary) {
                Path renamed;
                feature = this.session.getFeature(Move.class);
                if (feature.isSupported(file, renamed = new Path(file.getParent(), MessageFormat.format(this.preferences.getProperty("queue.upload.file.temporary.format"), file.getName(), new AlphanumericRandomStringService().random()), file.getType()))) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set temporary filename %s", renamed));
                    }
                    status.withRename(renamed).withDisplayname(file);
                    status.getDisplayname().exists(status.isExists());
                } else {
                    log.warn(String.format("Cannot use temporary filename for upload with missing rename support for %s", file));
                }
            }
            status.withMime(new MappingMimeTypeService().getMime(file.getName()));
        }
        if (file.isDirectory()) {
            status.setLength(0L);
        }
        if (this.options.permissions) {
            feature = this.session.getFeature(UnixPermission.class);
            if (feature != null) {
                if (status.isExists()) {
                    status.setPermission(status.getRemote().getPermission());
                } else {
                    status.setPermission(feature.getDefault(local));
                }
            } else {
                status.setPermission(Permission.EMPTY);
            }
        }
        if (this.options.acl) {
            feature = this.session.getFeature(AclPermission.class);
            if (feature != null) {
                if (status.isExists()) {
                    progress.message(MessageFormat.format(LocaleFactory.localizedString("Getting permission of {0}", "Status"), file.getName()));
                    try {
                        status.setAcl(feature.getPermission(file));
                    }
                    catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                        status.setAcl(feature.getDefault(file, local));
                    }
                } else {
                    status.setAcl(feature.getDefault(file, local));
                }
            } else {
                status.setAcl(Acl.EMPTY);
            }
        }
        if (this.options.timestamp) {
            feature = this.session.getFeature(Timestamp.class);
            if (feature != null) {
                status.setTimestamp(feature.getDefault(local));
            } else if (1L != local.attributes().getModificationDate()) {
                status.setTimestamp(local.attributes().getModificationDate());
            }
        }
        if (this.options.metadata && (feature = this.session.getFeature(Headers.class)) != null) {
            if (status.isExists()) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
                try {
                    status.setMetadata(feature.getMetadata(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    status.setMetadata(feature.getDefault(local));
                }
            } else {
                status.setMetadata(feature.getDefault(local));
            }
        }
        if (this.options.encryption && (feature = this.session.getFeature(Encryption.class)) != null) {
            if (status.isExists()) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
                try {
                    status.setEncryption(feature.getEncryption(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    status.setEncryption(feature.getDefault(file));
                }
            } else {
                status.setEncryption(feature.getDefault(file));
            }
        }
        if (this.options.redundancy && file.isFile() && (feature = this.session.getFeature(Redundancy.class)) != null) {
            if (status.isExists()) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
                try {
                    status.setStorageClass(feature.getClass(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    status.setStorageClass(feature.getDefault());
                }
            } else {
                status.setStorageClass(feature.getDefault());
            }
        }
        if (this.options.checksum && file.isFile() && (feature = this.session.getFeature(Write.class).checksum(file, status)) != null) {
            progress.message(MessageFormat.format(LocaleFactory.localizedString("Calculate checksum for {0}", "Status"), file.getName()));
            try {
                status.setChecksum(feature.compute(local.getInputStream(), status));
            }
            catch (LocalAccessDeniedException e) {
                log.warn(e.getMessage());
            }
        }
        return status;
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (status.getRename().remote != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Clear exist flag for file %s", local));
            }
            status.setExists(false);
        }
    }

    @Override
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Complete %s with status %s", file.getAbsolute(), status));
        }
        if (status.isComplete()) {
            Object feature;
            if (!Permission.EMPTY.equals(status.getPermission()) && (feature = this.session.getFeature(UnixPermission.class)) != null) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), file.getName(), status.getPermission()));
                    feature.setUnixPermission(file, status.getPermission());
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
            if (!Acl.EMPTY.equals(status.getAcl()) && (feature = this.session.getFeature(AclPermission.class)) != null) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), file.getName(), status.getAcl()));
                    feature.setPermission(file, status.getAcl());
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
            if (status.getTimestamp() != null && !this.session.getFeature(Write.class).timestamp() && (feature = this.session.getFeature(Timestamp.class)) != null) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing timestamp of {0} to {1}", "Status"), file.getName(), UserDateFormatterFactory.get().getShortFormat(status.getTimestamp())));
                    feature.setTimestamp(file, status);
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
            if (file.isFile() && status.getDisplayname().remote != null) {
                Move move = this.session.getFeature(Move.class);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Rename file %s to %s", file, status.getDisplayname().remote));
                }
                move.move(file, status.getDisplayname().remote, new TransferStatus(status).exists(status.getDisplayname().exists), new Delete.DisabledCallback(), new DisabledConnectionCallback());
            }
        }
    }
}

