/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.synchronisation;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronizationPathFilter
implements TransferPathFilter {
    private static final Logger log = LogManager.getLogger(SynchronizationPathFilter.class);
    private final ComparePathFilter comparison;
    private final TransferPathFilter downloadFilter;
    private final TransferPathFilter uploadFilter;
    private final TransferAction action;

    public SynchronizationPathFilter(ComparePathFilter comparison, TransferPathFilter downloadFilter, TransferPathFilter uploadFilter, TransferAction action) {
        this.comparison = comparison;
        this.downloadFilter = downloadFilter;
        this.uploadFilter = uploadFilter;
        this.action = action;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener listener) throws BackgroundException {
        switch (this.comparison.compare(file, local, listener)) {
            case remote: {
                return this.downloadFilter.prepare(file, local, parent, listener);
            }
            case local: {
                return this.uploadFilter.prepare(file, local, parent, listener);
            }
        }
        return this.uploadFilter.prepare(file, local, parent, listener).exists(true);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        switch (this.comparison.compare(file, local, new DisabledProgressListener())) {
            case equal: {
                return file.isDirectory();
            }
            case remote: {
                if (this.action.equals(TransferAction.upload)) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison result %s because action is %s", new Object[]{file, Comparison.remote, this.action}));
                    }
                    return false;
                }
                return this.downloadFilter.accept(file, local, parent);
            }
            case local: {
                if (this.action.equals(TransferAction.download)) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison result %s because action is %s", new Object[]{file, Comparison.local, this.action}));
                    }
                    return false;
                }
                return this.uploadFilter.accept(file, local, parent);
            }
        }
        return false;
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        switch (this.comparison.compare(file, local, listener)) {
            case remote: {
                this.downloadFilter.apply(file, local, status, listener);
                break;
            }
            case local: {
                this.uploadFilter.apply(file, local, status, listener);
            }
        }
    }

    @Override
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        switch (this.comparison.compare(file, local, listener)) {
            case remote: {
                this.downloadFilter.complete(file, local, status, listener);
                break;
            }
            case local: {
                this.uploadFilter.complete(file, local, status, listener);
            }
        }
    }

    @Override
    public TransferPathFilter withFinder(Find finder) {
        this.downloadFilter.withFinder(finder);
        this.uploadFilter.withFinder(finder);
        return this;
    }

    @Override
    public TransferPathFilter withAttributes(AttributesFinder attributes) {
        this.downloadFilter.withAttributes(attributes);
        this.uploadFilter.withAttributes(attributes);
        return null;
    }
}

