/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.download.SkipFilter;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashFilter
extends AbstractDownloadFilter {
    private static final Logger log = LogManager.getLogger(SkipFilter.class);
    private final Trash feature = LocalTrashFactory.get();

    public TrashFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session) {
        super(symlinkResolver, session, new DownloadFilterOptions(session.getHost()));
    }

    public TrashFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (status.isExists()) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Trash file %s", local));
            }
            try {
                this.feature.trash(local);
            }
            catch (AccessDeniedException e) {
                log.warn(e.getMessage());
            }
        }
        super.apply(file, local, status, listener);
    }
}

