/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenameExistingFilter
extends AbstractDownloadFilter {
    private static final Logger log = LogManager.getLogger(RenameExistingFilter.class);

    public RenameExistingFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session) {
        super(symlinkResolver, session, new DownloadFilterOptions(session.getHost()));
    }

    public RenameExistingFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (status.isExists()) {
            if (local.attributes().getSize() == 0L) {
                log.warn(String.format("Skip renaming placeholder file %s", local));
            } else {
                String proposal;
                Local rename;
                do {
                    proposal = MessageFormat.format(PreferencesFactory.get().getProperty("queue.download.file.rename.format"), FilenameUtils.getBaseName((String)file.getName()), UserDateFormatterFactory.get().getMediumFormat(System.currentTimeMillis(), false).replace(local.getDelimiter(), '-').replace(':', '-'), StringUtils.isNotBlank((CharSequence)file.getExtension()) ? String.format(".%s", file.getExtension()) : "");
                } while ((rename = LocalFactory.get(local.getParent().getAbsolute(), proposal)).exists());
                if (log.isInfoEnabled()) {
                    log.info(String.format("Rename existing file %s to %s", local, rename));
                }
                LocalFactory.get(local.getAbsolute()).rename(rename);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Clear exist flag for file %s", local));
                }
                status.setExists(false);
            }
        }
        super.apply(file, local, status, listener);
    }
}

