/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.IconService;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class IconUpdateStreamListener
extends BytecountStreamListener {
    private final IconService icon = IconServiceFactory.get();
    private final TransferStatus status;
    private final Local file;
    private int step = 0;

    public IconUpdateStreamListener(StreamListener delegate, TransferStatus status, Local file) {
        super(delegate);
        this.status = status;
        this.file = file;
    }

    @Override
    public void sent(long bytes) {
        super.sent(bytes);
        BigDecimal fraction = new BigDecimal(this.getSent()).divide(new BigDecimal(this.status.getLength()), 1, RoundingMode.DOWN);
        if (fraction.multiply(BigDecimal.TEN).intValue() > this.step) {
            this.icon.set(this.file, this.status);
            ++this.step;
        }
    }
}

