/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.DefaultComparePathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompareFilter
extends AbstractDownloadFilter {
    private static final Logger log = LogManager.getLogger(CompareFilter.class);
    private final ProgressListener listener;
    private final ComparePathFilter comparison;

    public CompareFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, ProgressListener listener) {
        this(symlinkResolver, session, new DownloadFilterOptions(session.getHost()), listener);
    }

    public CompareFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options, ProgressListener listener) {
        this(symlinkResolver, session, options, listener, new DefaultComparePathFilter(session, session.getHost().getTimezone()));
    }

    public CompareFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options, ProgressListener listener, ComparePathFilter comparison) {
        super(symlinkResolver, session, options);
        this.listener = listener;
        this.comparison = comparison;
    }

    @Override
    public AbstractDownloadFilter withFinder(Find finder) {
        this.comparison.withFinder(finder);
        return super.withFinder(finder);
    }

    @Override
    public AbstractDownloadFilter withAttributes(AttributesFinder attributes) {
        this.comparison.withAttributes(attributes);
        return super.withAttributes(attributes);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (super.accept(file, local, parent)) {
            Comparison comparison = this.comparison.compare(file, local, this.listener);
            switch (comparison) {
                case local: {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
                case equal: {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
                case remote: {
                    return true;
                }
            }
            log.warn(String.format("Invalid comparison result %s", new Object[]{comparison}));
        }
        return false;
    }
}

