/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.copy;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.copy.AbstractCopyFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumFilter
extends AbstractCopyFilter {
    private static final Logger log = LogManager.getLogger(ChecksumFilter.class);

    public ChecksumFilter(Session<?> source, Session<?> destination, Map<Path, Path> files) {
        super(source, destination, files);
    }

    public ChecksumFilter(Session<?> source, Session<?> destination, Map<Path, Path> files, UploadFilterOptions options) {
        super(source, destination, files, options);
    }

    @Override
    public boolean accept(Path source, Local local, TransferStatus parent) throws BackgroundException {
        Path target = (Path)this.files.get(source);
        if (source.isFile() && parent.isExists() && this.find.find(target) && Checksum.NONE != source.attributes().getChecksum()) {
            PathAttributes targetAttributes = this.attribute.find(target);
            if (Checksum.NONE != targetAttributes.getChecksum()) {
                if (Objects.equals(source.attributes().getChecksum(), targetAttributes.getChecksum())) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Skip file %s with checksum %s", source, targetAttributes.getChecksum()));
                    }
                    return false;
                }
                log.warn(String.format("Checksum mismatch for %s and %s", source, target));
            } else {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Skip file %s with remote size %d", source, targetAttributes.getSize()));
                }
                return false;
            }
        }
        return true;
    }
}

