/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.copy;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.ui.browser.SearchFilterFactory;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCopyFilter
implements TransferPathFilter {
    private static final Logger log = LogManager.getLogger(AbstractCopyFilter.class);
    protected final Session<?> sourceSession;
    protected final Session<?> targetSession;
    protected final Map<Path, Path> files;
    private final Filter<Path> hidden = SearchFilterFactory.HIDDEN_FILTER;
    protected Find find;
    protected AttributesFinder attribute;
    private final UploadFilterOptions options;

    public AbstractCopyFilter(Session<?> source, Session<?> destination, Map<Path, Path> files) {
        this(source, destination, files, new UploadFilterOptions(destination.getHost()));
    }

    public AbstractCopyFilter(Session<?> source, Session<?> destination, Map<Path, Path> files, UploadFilterOptions options) {
        this.sourceSession = source;
        this.targetSession = destination;
        this.files = files;
        this.options = options;
        this.find = destination.getFeature(Find.class, new DefaultFindFeature(destination));
        this.attribute = destination.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(destination));
    }

    @Override
    public AbstractCopyFilter withFinder(Find finder) {
        this.find = finder;
        return this;
    }

    @Override
    public AbstractCopyFilter withAttributes(AttributesFinder attributes) {
        this.attribute = attributes;
        return this;
    }

    @Override
    public TransferStatus prepare(Path file, Local n, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        Object targetFeature3;
        Object targetFeature2;
        Object sourceFeature;
        Path target;
        TransferStatus status = new TransferStatus().hidden(!this.hidden.accept(file)).withLockId(parent.getLockId());
        if (parent.isExists() && this.find.find(target = this.files.get(file))) {
            status.setExists(true);
            status.setRemote(this.attribute.find(target));
        }
        PathAttributes attributes = ((AttributesFinder)this.sourceSession.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(this.sourceSession))).find(file);
        if (file.isFile()) {
            status.setLength(attributes.getSize());
        }
        if (file.isDirectory()) {
            status.setLength(0L);
        }
        if (this.options.permissions) {
            status.setPermission(attributes.getPermission());
        }
        if (this.options.acl) {
            sourceFeature = this.sourceSession.getFeature(AclPermission.class);
            if (sourceFeature != null) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Getting permission of {0}", "Status"), file.getName()));
                try {
                    status.setAcl(sourceFeature.getPermission(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    targetFeature2 = this.targetSession.getFeature(AclPermission.class);
                    if (targetFeature2 != null) {
                        status.setAcl(targetFeature2.getDefault(file.getType()));
                    }
                }
            } else {
                targetFeature3 = this.targetSession.getFeature(AclPermission.class);
                if (targetFeature3 != null) {
                    status.setAcl(targetFeature3.getDefault(file.getType()));
                }
            }
        }
        if (this.options.timestamp) {
            status.setTimestamp(attributes.getModificationDate());
        }
        if (this.options.metadata && (sourceFeature = this.sourceSession.getFeature(Headers.class)) != null) {
            progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
            try {
                status.setMetadata(sourceFeature.getMetadata(file));
            }
            catch (AccessDeniedException | InteroperabilityException | NotfoundException targetFeature3) {
                // empty catch block
            }
        }
        if (this.options.encryption) {
            sourceFeature = this.sourceSession.getFeature(Encryption.class);
            if (sourceFeature != null) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
                try {
                    status.setEncryption(sourceFeature.getEncryption(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    targetFeature2 = this.targetSession.getFeature(Encryption.class);
                    if (targetFeature2 != null) {
                        status.setEncryption(targetFeature2.getDefault(file));
                    }
                }
            } else {
                targetFeature3 = this.targetSession.getFeature(Encryption.class);
                if (targetFeature3 != null) {
                    status.setEncryption(targetFeature3.getDefault(file));
                }
            }
        }
        if (this.options.redundancy && file.isFile()) {
            sourceFeature = this.sourceSession.getFeature(Redundancy.class);
            if (sourceFeature != null) {
                progress.message(MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), file.getName()));
                try {
                    status.setStorageClass(sourceFeature.getClass(file));
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
                    targetFeature2 = this.targetSession.getFeature(Redundancy.class);
                    if (targetFeature2 != null) {
                        status.setStorageClass(targetFeature2.getDefault());
                    }
                }
            } else {
                targetFeature3 = this.targetSession.getFeature(Redundancy.class);
                if (targetFeature3 != null) {
                    status.setStorageClass(targetFeature3.getDefault());
                }
            }
        }
        if (this.options.checksum) {
            status.setChecksum(file.attributes().getChecksum());
        }
        return status;
    }

    @Override
    public void apply(Path source, Local n, TransferStatus status, ProgressListener listener) {
    }

    @Override
    public void complete(Path source, Local n, TransferStatus status, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Complete %s with status %s", source.getAbsolute(), status));
        }
        if (status.isComplete()) {
            Timestamp timestamp;
            Object feature;
            Path target = this.files.get(source);
            if (!Permission.EMPTY.equals(status.getPermission()) && (feature = this.targetSession.getFeature(UnixPermission.class)) != null && !Permission.EMPTY.equals(status.getPermission())) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), target.getName(), status.getPermission()));
                    feature.setUnixPermission(target, status.getPermission());
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
            if (!Acl.EMPTY.equals(status.getAcl()) && (feature = this.targetSession.getFeature(AclPermission.class)) != null) {
                try {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), target.getName(), status.getAcl()));
                    feature.setPermission(target, status.getAcl());
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
            if (status.getTimestamp() != null && (timestamp = this.targetSession.getFeature(Timestamp.class)) != null) {
                listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing timestamp of {0} to {1}", "Status"), target.getName(), UserDateFormatterFactory.get().getShortFormat(status.getTimestamp())));
                try {
                    timestamp.setTimestamp(target, status);
                }
                catch (BackgroundException e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }
}

