/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.filter.UploadRegexFilter;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.normalizer.UploadRootPathsNormalizer;
import ch.cyberduck.core.transfer.symlink.UploadSymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.CompareFilter;
import ch.cyberduck.core.transfer.upload.OverwriteFilter;
import ch.cyberduck.core.transfer.upload.RenameExistingFilter;
import ch.cyberduck.core.transfer.upload.RenameFilter;
import ch.cyberduck.core.transfer.upload.ResumeFilter;
import ch.cyberduck.core.transfer.upload.SkipFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.transfer.upload.UploadRegexPriorityComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadTransfer
extends Transfer {
    private static final Logger log = LogManager.getLogger(UploadTransfer.class);
    private final Filter<Local> filter;
    private final Comparator<Local> comparator;
    private Cache<Path> cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private UploadFilterOptions options = new UploadFilterOptions(this.host);

    public UploadTransfer(Host host, Path root, Local local) {
        this(host, Collections.singletonList(new TransferItem(root, local)), PreferencesFactory.get().getBoolean("queue.upload.skip.enable") ? new UploadRegexFilter() : new NullFilter());
    }

    public UploadTransfer(Host host, Path root, Local local, Filter<Local> f) {
        this(host, Collections.singletonList(new TransferItem(root, local)), f);
    }

    public UploadTransfer(Host host, List<TransferItem> roots) {
        this(host, roots, PreferencesFactory.get().getBoolean("queue.upload.skip.enable") ? new UploadRegexFilter() : new NullFilter());
    }

    public UploadTransfer(Host host, List<TransferItem> roots, Filter<Local> f) {
        this(host, roots, f, new UploadRegexPriorityComparator());
    }

    public UploadTransfer(Host host, List<TransferItem> roots, Filter<Local> f, Comparator<Local> comparator) {
        super(host, roots, new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.upload.bandwidth.bytes")));
        this.filter = f;
        this.comparator = comparator;
    }

    @Override
    public Transfer withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public Transfer withOptions(UploadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.upload;
    }

    @Override
    public List<TransferItem> list(Session<?> session, Path remote, Local directory, ListProgressListener listener) throws BackgroundException {
        Symlink symlink;
        if (log.isDebugEnabled()) {
            log.debug(String.format("List children for %s", directory));
        }
        if (directory.isSymbolicLink() && new UploadSymlinkResolver(symlink = session.getFeature(Symlink.class), this.roots).resolve(directory)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Do not list children for symbolic link %s", directory));
            }
            return Collections.emptyList();
        }
        ArrayList<TransferItem> children = new ArrayList<TransferItem>();
        for (Local local : directory.list().filter(this.comparator, this.filter)) {
            children.add(new TransferItem(new Path(remote, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
        }
        return children;
    }

    @Override
    public AbstractUploadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        CachingAttributesFinderFeature attributes;
        CachingFindFeature find;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Filter transfer with action %s and options %s", action, this.options));
        }
        Symlink symlink = source.getFeature(Symlink.class);
        UploadSymlinkResolver resolver = new UploadSymlinkResolver(symlink, this.roots);
        if (this.roots.size() > 1 || this.roots.stream().filter(item -> item.remote.isDirectory()).findAny().isPresent()) {
            find = new CachingFindFeature(this.cache, source.getFeature(Find.class, new DefaultFindFeature(source)));
            attributes = new CachingAttributesFinderFeature(this.cache, source.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(source)));
        } else {
            find = new CachingFindFeature(this.cache, source.getFeature(Find.class));
            attributes = new CachingAttributesFinderFeature(this.cache, source.getFeature(AttributesFinder.class));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Determined features %s and %s", find, attributes));
        }
        if (action.equals(TransferAction.resume)) {
            return new ResumeFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.rename)) {
            return new RenameFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.renameexisting)) {
            return new RenameExistingFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.skip)) {
            return new SkipFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.comparison)) {
            return new CompareFilter(resolver, source, this.options, listener).withFinder(find).withAttributes(attributes);
        }
        return new OverwriteFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            return TransferAction.resume;
        }
        TransferAction action = reloadRequested ? TransferAction.forName(PreferencesFactory.get().getProperty("queue.upload.reload.action")) : TransferAction.forName(PreferencesFactory.get().getProperty("queue.upload.action"));
        if (action.equals(TransferAction.callback)) {
            for (TransferItem upload : this.roots) {
                if (!new CachingFindFeature(this.cache, source.getFeature(Find.class, new DefaultFindFeature(source))).find(upload.remote) || upload.remote.isDirectory() && this.list(source, upload.remote, upload.local, listener).isEmpty()) continue;
                return prompt.prompt(upload);
            }
            return TransferAction.overwrite;
        }
        return action;
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferPathFilter filter, TransferErrorCallback error, ProgressListener progress, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        Object id = feature.pre(Transfer.Type.upload, files, callback);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Obtained bulk id %s for transfer %s", id, this));
        }
        super.pre(source, destination, files, filter, error, progress, callback);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Filter for directories in transfer %s", this));
        }
        List directories = files.entrySet().stream().filter(item -> ((TransferItem)item.getKey()).remote.isDirectory()).filter(item -> !((TransferStatus)item.getValue()).isExists()).sorted((Comparator<Map.Entry>)new Comparator<Map.Entry<TransferItem, TransferStatus>>(){

            @Override
            public int compare(Map.Entry<TransferItem, TransferStatus> o1, Map.Entry<TransferItem, TransferStatus> o2) {
                if (o1.getKey().remote.isChild(o2.getKey().remote)) {
                    return 1;
                }
                if (o2.getKey().remote.isChild(o1.getKey().remote)) {
                    return -1;
                }
                return Integer.compare(StringUtils.countMatches((CharSequence)o1.getKey().remote.getAbsolute(), (char)'/'), StringUtils.countMatches((CharSequence)o2.getKey().remote.getAbsolute(), (char)'/'));
            }
        }).collect(Collectors.toList());
        Directory mkdir = source.getFeature(Directory.class);
        for (Map.Entry entry : directories) {
            Path file = ((TransferItem)entry.getKey()).remote;
            TransferStatus status = (TransferStatus)entry.getValue();
            if (status.isExists()) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.format("Skip existing directory %s", file));
                continue;
            }
            status.validate();
            progress.message(MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), file.getName()));
            try {
                mkdir.mkdir(file, status);
                filter.complete(status.getRename().remote != null ? status.getRename().remote : ((TransferItem)entry.getKey()).remote, status.getRename().local != null ? status.getRename().local : ((TransferItem)entry.getKey()).local, status.complete(), progress);
            }
            catch (BackgroundException e) {
                if (error.prompt((TransferItem)entry.getKey(), status, e, files.size())) {
                    log.warn(String.format("Ignore transfer failure %s", e));
                    continue;
                }
                throw new TransferCanceledException(e);
            }
        }
    }

    @Override
    public void post(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferErrorCallback error, ProgressListener listener, ConnectionCallback callback) throws BackgroundException {
        block4: {
            Bulk feature = source.getFeature(Bulk.class);
            try {
                feature.post(Transfer.Type.upload, files, callback);
                super.post(source, destination, files, error, listener, callback);
            }
            catch (BackgroundException e) {
                Optional entry = files.entrySet().stream().findFirst();
                if (!entry.isPresent()) break block4;
                Map.Entry item = (Map.Entry)entry.get();
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Prompt with failure %s for item %s only", e, item.getKey()));
                }
                if (error.prompt((TransferItem)item.getKey(), (TransferStatus)item.getValue(), e, files.size())) {
                    log.warn(String.format("Ignore transfer failure %s", e));
                }
                throw new TransferCanceledException(e);
            }
        }
    }

    @Override
    public void transfer(Session<?> source, Session<?> destination, Path file, Local local, TransferOptions options, TransferStatus overall, TransferStatus segment, ConnectionCallback connectionCallback, ProgressListener listener, StreamListener streamListener) throws BackgroundException {
        Symlink feature;
        UploadSymlinkResolver symlinkResolver;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Transfer file %s with options %s", file, options));
        }
        if (local.isSymbolicLink() && (symlinkResolver = new UploadSymlinkResolver(feature = source.getFeature(Symlink.class), this.roots)).resolve(local)) {
            String target = symlinkResolver.relativize(local.getAbsolute(), local.getSymlinkTarget().getAbsolute());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Create symbolic link from %s to %s", file, target));
            }
            feature.symlink(file, target);
            return;
        }
        if (file.isFile()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), file.getName()));
            Upload upload = source.getFeature(Upload.class);
            Object Reply = upload.upload(file, local, this.bandwidth, new UploadStreamListener(this, streamListener), segment, connectionCallback);
        }
    }

    @Override
    public void normalize() {
        List<TransferItem> normalized = new UploadRootPathsNormalizer().normalize(this.roots);
        this.roots.clear();
        this.roots.addAll(normalized);
    }

    @Override
    public void stop() {
        this.cache.clear();
        super.stop();
    }

    private static final class UploadStreamListener
    extends DelegateStreamListener {
        private final UploadTransfer transfer;

        public UploadStreamListener(UploadTransfer transfer, StreamListener delegate) {
            super(delegate);
            this.transfer = transfer;
        }

        @Override
        public void sent(long bytes) {
            this.transfer.addTransferred(bytes);
            super.sent(bytes);
        }
    }
}

