/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.transfer.Speedometer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferProgress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferSpeedometer
extends Speedometer {
    private static final Logger log = LogManager.getLogger(TransferSpeedometer.class);
    private final Transfer transfer;

    public TransferSpeedometer(Transfer transfer) {
        this.transfer = transfer;
    }

    public TransferProgress getStatus() {
        return this.getStatus(this.transfer.isRunning());
    }

    public TransferProgress getStatus(boolean plain) {
        Long transferred = this.transfer.getTransferred();
        Long size = this.transfer.getSize();
        Double speed = this.getSpeed(transferred, false);
        return new TransferProgress(size, transferred, this.getProgress(this.transfer.isRunning(), size, transferred, plain, speed), speed);
    }

    public void reset() {
        long timestamp = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reset with timestamp %d", timestamp));
        }
        this.reset(timestamp, this.transfer.getTransferred());
    }
}

