/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.local.ApplicationBadgeLabeler;
import ch.cyberduck.core.local.ApplicationBadgeLabelerFactory;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TransferQueue {
    private static final Logger log = LogManager.getLogger(TransferQueue.class);
    private final ApplicationBadgeLabeler label = ApplicationBadgeLabelerFactory.get();
    private final NotificationService notification = NotificationServiceFactory.get();
    private final ResizeableSemaphore semaphore;
    private int permits;

    public TransferQueue() {
        this(PreferencesFactory.get().getInteger("queue.connections.limit"));
    }

    public TransferQueue(int size) {
        this.permits = size == 0 ? PreferencesFactory.get().getInteger("queue.connections.limit.default") : size;
        this.semaphore = new ResizeableSemaphore(this.permits, true);
    }

    public void add(Transfer t, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add transfer %s to queue", t));
        }
        if (!this.semaphore.tryAcquire()) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Queuing transfer %s", t));
            }
            listener.message(LocaleFactory.localizedString("Maximum allowed connections exceeded. Waiting", "Status"));
            this.notification.notify(t.getName(), t.getUuid(), "Transfer queued", t.getName());
            this.semaphore.acquireUninterruptibly();
        }
        this.label.badge(String.valueOf(this.permits - this.semaphore.availablePermits() + this.semaphore.getQueueLength()));
    }

    public void remove(Transfer t) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove %s from queue", t));
        }
        this.semaphore.release();
        int size = this.permits - this.semaphore.availablePermits() + this.semaphore.getQueueLength();
        if (0 == size) {
            this.label.clear();
        } else {
            this.label.badge(String.valueOf(size));
        }
    }

    public void resize(int size) {
        int limit;
        int n = limit = size == 0 ? PreferencesFactory.get().getInteger("queue.connections.limit.default") : size;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Resize queue to %d", limit));
        }
        if (limit < this.permits) {
            this.semaphore.reducePermits(this.permits - limit);
        } else {
            this.semaphore.release(limit - this.permits);
        }
        this.permits = limit;
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        public ResizeableSemaphore(int permits, boolean fair) {
            super(permits, fair);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

