/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.serializer.Serializer;
import java.util.Objects;

public class TransferItem
implements Referenceable,
Serializable {
    public Path remote;
    public Local local;

    public TransferItem(Path remote) {
        this(remote, null);
    }

    public TransferItem(Path remote, Local local) {
        this.remote = remote;
        this.local = local;
    }

    @Override
    public <T> T serialize(Serializer<T> dict) {
        dict.setObjectForKey(this.remote, "Remote");
        if (this.local != null) {
            dict.setObjectForKey(this.local, "Local Dictionary");
        }
        return dict.getSerialized();
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public void setRemote(Path remote) {
        this.remote = remote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferItem that = (TransferItem)o;
        if (!Objects.equals(this.local, that.local)) {
            return false;
        }
        return !(this.remote != null ? !new SimplePathPredicate(this.remote).equals(new SimplePathPredicate(that.remote)) : that.remote != null);
    }

    public int hashCode() {
        int result = this.remote != null ? new SimplePathPredicate(this.remote).hashCode() : 0;
        result = 31 * result + (this.local != null ? this.local.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransferItem{");
        sb.append("remote=").append(this.remote);
        sb.append(", local=").append(this.local);
        sb.append('}');
        return sb.toString();
    }
}

