/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronizingTransferErrorCallback
implements TransferErrorCallback {
    private static final Logger log = LogManager.getLogger(SynchronizingTransferErrorCallback.class);
    private final TransferErrorCallback proxy;
    private final Lock lock = new ReentrantLock();

    public SynchronizingTransferErrorCallback(TransferErrorCallback proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prompt(TransferItem item, TransferStatus status, BackgroundException failure, int pending) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Await lock %s", this.lock));
        }
        this.lock.lock();
        try {
            boolean bl = this.proxy.prompt(item, status, failure, pending);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

