/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.date.PeriodFormatter;
import ch.cyberduck.core.date.RemainingPeriodFormatter;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;

public class Speedometer {
    private final SizeFormatter sizeFormatter;
    private long timestamp;
    private long last = 0L;
    private final PeriodFormatter periodFormatter = new RemainingPeriodFormatter();

    public Speedometer() {
        this(System.currentTimeMillis());
    }

    public Speedometer(long timestamp) {
        this(timestamp, PreferencesFactory.get().getBoolean("browser.filesize.decimal"));
        this.timestamp = timestamp;
    }

    public Speedometer(long timestamp, boolean decimal) {
        this.timestamp = timestamp;
        this.sizeFormatter = SizeFormatterFactory.get(decimal);
    }

    protected Double getSpeed(long transferred) {
        return this.getSpeed(transferred, true);
    }

    protected Double getSpeed(long transferred, boolean reset) {
        return this.getSpeed(System.currentTimeMillis(), transferred, reset);
    }

    protected Double getSpeed(long time, long transferred, boolean reset) {
        long elapsed = time - this.timestamp;
        if (elapsed > 0L) {
            long differential = transferred - this.last;
            if (reset) {
                this.reset(time, transferred);
            }
            return (double)differential / (double)elapsed;
        }
        return 0.0;
    }

    public String getProgress(boolean running, long size, long transferred) {
        return this.getProgress(System.currentTimeMillis(), running, size, transferred);
    }

    public String getProgress(long time, boolean running, long size, long transferred) {
        return this.getProgress(running, size, transferred, running, this.getSpeed(time, transferred, true));
    }

    public String getProgress(boolean running, long size, long transferred, boolean plain, Double speed) {
        StringBuilder b = new StringBuilder(MessageFormat.format(LocaleFactory.localizedString("{0} of {1}"), this.sizeFormatter.format(transferred, plain), this.sizeFormatter.format(size)));
        if (running && transferred > 0L && size > 0L) {
            b.append(" (");
            b.append((int)((double)transferred / (double)size * 100.0));
            b.append("%");
            b.append(", ");
            b.append(SizeFormatterFactory.get(true).format(new BigDecimal(speed * 1000.0).setScale(0, RoundingMode.UP).longValue()));
            b.append("/sec");
            if (speed > 0.0 && transferred < size) {
                b.append(", ");
                long remaining = new BigDecimal((double)(size - transferred) / speed).setScale(0, RoundingMode.UP).longValue();
                b.append(this.periodFormatter.format(new BigDecimal(remaining).divide(new BigDecimal(1000L), RoundingMode.UP).longValue()));
            }
            b.append(")");
        }
        return b.toString();
    }

    public void reset(Long timestamp, Long transferred) {
        this.timestamp = timestamp;
        this.last = transferred;
    }
}

