/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.filter.DownloadDuplicateFilter;
import ch.cyberduck.core.filter.DownloadRegexFilter;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.LocalSymlinkFactory;
import ch.cyberduck.core.local.features.Symlink;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.CompareFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.download.DownloadRegexPriorityComparator;
import ch.cyberduck.core.transfer.download.IconUpdateStreamListener;
import ch.cyberduck.core.transfer.download.OverwriteFilter;
import ch.cyberduck.core.transfer.download.RenameExistingFilter;
import ch.cyberduck.core.transfer.download.RenameFilter;
import ch.cyberduck.core.transfer.download.ResumeFilter;
import ch.cyberduck.core.transfer.download.SkipFilter;
import ch.cyberduck.core.transfer.download.TrashFilter;
import ch.cyberduck.core.transfer.normalizer.DownloadRootPathsNormalizer;
import ch.cyberduck.core.transfer.symlink.DownloadSymlinkResolver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadTransfer
extends Transfer {
    private static final Logger log = LogManager.getLogger(DownloadTransfer.class);
    private final Filter<Path> filter;
    private final Comparator<Path> comparator;
    private final DownloadSymlinkResolver symlinkResolver;
    private Cache<Path> cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private DownloadFilterOptions options = new DownloadFilterOptions(this.host);

    public DownloadTransfer(Host host, Path root, Local local) {
        this(host, Collections.singletonList(new TransferItem(root, local)), PreferencesFactory.get().getBoolean("queue.download.skip.enable") ? new DownloadRegexFilter() : new DownloadDuplicateFilter());
    }

    public DownloadTransfer(Host host, Path root, Local local, Filter<Path> f) {
        this(host, Collections.singletonList(new TransferItem(root, local)), f);
    }

    public DownloadTransfer(Host host, List<TransferItem> roots) {
        this(host, roots, PreferencesFactory.get().getBoolean("queue.download.skip.enable") ? new DownloadRegexFilter() : new DownloadDuplicateFilter());
    }

    public DownloadTransfer(Host host, List<TransferItem> roots, Filter<Path> f) {
        this(host, roots, f, new DownloadRegexPriorityComparator());
    }

    public DownloadTransfer(Host host, List<TransferItem> roots, Filter<Path> f, Comparator<Path> comparator) {
        super(host, roots, new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.download.bandwidth.bytes")));
        this.filter = f;
        this.comparator = comparator;
        this.symlinkResolver = new DownloadSymlinkResolver(roots);
    }

    @Override
    public DownloadTransfer withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public Transfer withOptions(DownloadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.download;
    }

    @Override
    public List<TransferItem> list(Session<?> session, Path directory, Local local, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> list;
        if (log.isDebugEnabled()) {
            log.debug(String.format("List children for %s", directory));
        }
        if (directory.isSymbolicLink() && new DownloadSymlinkResolver(this.roots).resolve(directory)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Do not list children for symbolic link %s", directory));
            }
            return Collections.emptyList();
        }
        if (this.cache.isCached(directory)) {
            list = this.cache.get(directory);
        } else {
            list = session.getFeature(ListService.class).list(directory, listener);
            this.cache.put(directory, list);
        }
        ArrayList<TransferItem> children = new ArrayList<TransferItem>();
        for (Path f : new AttributedList<Path>(list.filter(this.comparator, this.filter))) {
            children.add(new TransferItem(f, LocalFactory.get(local, f.getName())));
        }
        return children;
    }

    @Override
    public AbstractDownloadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        CachingAttributesFinderFeature attributes;
        CachingFindFeature find;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Filter transfer with action %s and options %s", action, this.options));
        }
        DownloadSymlinkResolver resolver = new DownloadSymlinkResolver(this.roots);
        if (this.roots.size() > 1 || this.roots.stream().filter(item -> item.remote.isDirectory()).findAny().isPresent()) {
            find = new CachingFindFeature(this.cache, source.getFeature(Find.class, new DefaultFindFeature(source)));
            attributes = new CachingAttributesFinderFeature(this.cache, source.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(source)));
        } else {
            find = new CachingFindFeature(this.cache, source.getFeature(Find.class));
            attributes = new CachingAttributesFinderFeature(this.cache, source.getFeature(AttributesFinder.class));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Determined features %s and %s", find, attributes));
        }
        if (action.equals(TransferAction.resume)) {
            return new ResumeFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.rename)) {
            return new RenameFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.renameexisting)) {
            return new RenameExistingFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.skip)) {
            return new SkipFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.trash)) {
            return new TrashFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
        }
        if (action.equals(TransferAction.comparison)) {
            return new CompareFilter(resolver, source, this.options, listener).withFinder(find).withAttributes(attributes);
        }
        return new OverwriteFilter(resolver, source, this.options).withFinder(find).withAttributes(attributes);
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            return TransferAction.resume;
        }
        TransferAction action = reloadRequested ? TransferAction.forName(PreferencesFactory.get().getProperty("queue.download.reload.action")) : TransferAction.forName(PreferencesFactory.get().getProperty("queue.download.action"));
        if (action.equals(TransferAction.callback)) {
            for (TransferItem download : this.roots) {
                Local local = download.local;
                if (!local.exists() || local.isDirectory() && local.list().isEmpty() || local.isFile() && local.attributes().getSize() == 0L) continue;
                return prompt.prompt(download);
            }
            return TransferAction.overwrite;
        }
        return action;
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferPathFilter filter, TransferErrorCallback error, ProgressListener progress, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        Object id = feature.pre(Transfer.Type.download, files, callback);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Obtained bulk id %s for transfer %s", id, this));
        }
        super.pre(source, destination, files, filter, error, progress, callback);
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            Path file = entry.getKey().remote;
            if (!file.isDirectory()) continue;
            TransferStatus status = entry.getValue();
            if (status.isExists()) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.format("Skip existing directory %s", file));
                continue;
            }
            Local local = entry.getKey().local;
            progress.message(MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), local.getName()));
            try {
                new DefaultLocalDirectoryFeature().mkdir(local);
                filter.complete(status.getRename().remote != null ? status.getRename().remote : entry.getKey().remote, status.getRename().local != null ? status.getRename().local : entry.getKey().local, status.complete(), progress);
            }
            catch (AccessDeniedException e) {
                if (error.prompt(entry.getKey(), status, e, files.size())) {
                    log.warn(String.format("Ignore transfer failure %s", e));
                    continue;
                }
                throw new TransferCanceledException(e);
            }
        }
    }

    @Override
    public void post(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferErrorCallback error, ProgressListener listener, ConnectionCallback callback) throws BackgroundException {
        block4: {
            Bulk feature = source.getFeature(Bulk.class);
            try {
                feature.post(Transfer.Type.download, files, callback);
                super.post(source, destination, files, error, listener, callback);
            }
            catch (BackgroundException e) {
                Optional entry = files.entrySet().stream().findFirst();
                if (!entry.isPresent()) break block4;
                Map.Entry item = (Map.Entry)entry.get();
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Prompt with failure %s for item %s only", e, item.getKey()));
                }
                if (error.prompt((TransferItem)item.getKey(), (TransferStatus)item.getValue(), e, files.size())) {
                    log.warn(String.format("Ignore transfer failure %s", e));
                }
                throw new TransferCanceledException(e);
            }
        }
    }

    @Override
    public void transfer(Session<?> source, Session<?> destination, Path file, Local local, TransferOptions options, TransferStatus overall, TransferStatus segment, ConnectionCallback connectionCallback, ProgressListener listener, StreamListener streamListener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Transfer file %s with options %s", file, options));
        }
        if (file.isSymbolicLink() && this.symlinkResolver.resolve(file)) {
            String target = this.symlinkResolver.relativize(file.getAbsolute(), file.getSymlinkTarget().getAbsolute());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Create symbolic link from %s to %s", local, target));
            }
            Symlink symlink = LocalSymlinkFactory.get();
            symlink.symlink(local, target);
            return;
        }
        if (file.isFile()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Downloading {0}", "Status"), file.getName()));
            Local folder = local.getParent();
            if (!folder.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(folder);
            }
            Download download = source.getFeature(Download.class);
            download.download(file, local, this.bandwidth, new DownloadStreamListener(this, this.options.icon && segment.getLength() > PreferencesFactory.get().getLong("queue.download.icon.threshold") && !overall.isSegmented() ? new IconUpdateStreamListener(streamListener, segment, local) : streamListener), segment, connectionCallback);
        }
    }

    @Override
    public void normalize() {
        List<TransferItem> normalized = new DownloadRootPathsNormalizer().normalize(this.roots);
        this.roots.clear();
        this.roots.addAll(normalized);
    }

    @Override
    public void stop() {
        this.cache.clear();
        super.stop();
    }

    private static final class DownloadStreamListener
    extends DelegateStreamListener {
        private final DownloadTransfer transfer;

        public DownloadStreamListener(DownloadTransfer transfer, StreamListener delegate) {
            super(delegate);
            this.transfer = transfer;
        }

        @Override
        public void recv(long bytes) {
            this.transfer.addTransferred(bytes);
            super.recv(bytes);
        }
    }
}

