/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.copy.ChecksumFilter;
import ch.cyberduck.core.transfer.copy.OverwriteFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CopyTransfer
extends Transfer {
    private static final Logger log = LogManager.getLogger(CopyTransfer.class);
    private final Filter<Path> filter = new NullFilter<Path>();
    private final Comparator<Path> comparator = new NullComparator<Path>();
    private Cache<Path> cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private final Map<Path, Path> mapping;
    private final Map<Path, Path> selected;
    private final Host destination;

    public CopyTransfer(Host source, Host destination, Map<Path, Path> selected) {
        this(source, destination, selected, new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.download.bandwidth.bytes")));
    }

    public CopyTransfer(Host source, Host destination, Map<Path, Path> selected, BandwidthThrottle bandwidth) {
        super(source, new ArrayList<TransferItem>(), bandwidth);
        this.destination = destination;
        this.selected = selected;
        this.mapping = new HashMap<Path, Path>(selected);
        for (Path f : selected.keySet()) {
            this.roots.add(new TransferItem(f));
        }
    }

    @Override
    public Transfer withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.copy;
    }

    @Override
    public Host getDestination() {
        return this.destination;
    }

    @Override
    public String getLocal() {
        return null;
    }

    @Override
    public <T> T serialize(Serializer<T> dict) {
        dict.setStringForKey(this.getType().name(), "Type");
        dict.setObjectForKey(this.host, "Host");
        if (this.destination != null) {
            dict.setObjectForKey(this.destination, "Destination");
        }
        dict.setListForKey(new ArrayList<Path>(this.selected.values()), "Destinations");
        dict.setListForKey(new ArrayList<Path>(this.selected.keySet()), "Roots");
        dict.setStringForKey(this.uuid, "UUID");
        dict.setStringForKey(String.valueOf(this.getSize()), "Size");
        dict.setStringForKey(String.valueOf(this.getTransferred()), "Current");
        if (this.timestamp != null) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Timestamp");
        }
        if (this.bandwidth != null) {
            dict.setStringForKey(String.valueOf(this.bandwidth.getRate()), "Bandwidth");
        }
        return dict.getSerialized();
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            return TransferAction.comparison;
        }
        TransferAction action = reloadRequested ? TransferAction.forName(PreferencesFactory.get().getProperty("queue.copy.reload.action")) : TransferAction.forName(PreferencesFactory.get().getProperty("queue.copy.action"));
        if (action.equals(TransferAction.callback)) {
            for (TransferItem upload : this.roots) {
                Path copy = this.mapping.get(upload.remote);
                Find find = destination.getFeature(Find.class);
                if (!find.find(copy) || upload.remote.isDirectory() && this.list(destination, copy, null, listener).isEmpty()) continue;
                return prompt.prompt(upload);
            }
            return TransferAction.overwrite;
        }
        return action;
    }

    @Override
    public TransferPathFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Filter transfer with action %s", action));
        }
        CachingFindFeature find = new CachingFindFeature(this.cache, destination.getFeature(Find.class, new DefaultFindFeature(destination)));
        CachingAttributesFinderFeature attributes = new CachingAttributesFinderFeature(this.cache, destination.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(destination)));
        if (action.equals(TransferAction.comparison)) {
            return new ChecksumFilter(source, destination, this.mapping).withFinder(find).withAttributes(attributes);
        }
        return new OverwriteFilter(source, destination, this.mapping).withFinder(find).withAttributes(attributes);
    }

    @Override
    public List<TransferItem> list(Session<?> session, Path directory, Local local, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("List children for %s", directory));
        }
        AttributedList<Path> list = session.getFeature(ListService.class).list(directory, listener).filter(this.comparator, this.filter);
        Path copy = this.mapping.get(directory);
        for (Path p : list) {
            this.mapping.put(p, new Path(copy, p.getName(), p.getType(), p.attributes()));
        }
        ArrayList<TransferItem> nullified = new ArrayList<TransferItem>();
        for (Path p : list) {
            nullified.add(new TransferItem(p));
        }
        return nullified;
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferPathFilter filter, TransferErrorCallback error, ProgressListener listener, ConnectionCallback callback) throws BackgroundException {
        Bulk download = source.getFeature(Bulk.class);
        Object id = download.pre(Transfer.Type.download, files, callback);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Obtained bulk id %s for transfer %s", id, this));
        }
        Bulk upload = destination.getFeature(Bulk.class);
        HashMap<TransferItem, TransferStatus> targets = new HashMap<TransferItem, TransferStatus>();
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            targets.put(new TransferItem(this.mapping.get(entry.getKey().remote)), entry.getValue());
        }
        Object id2 = upload.pre(Transfer.Type.upload, targets, callback);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Obtained bulk id %s for transfer %s", id2, this));
        }
    }

    @Override
    public void post(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, TransferErrorCallback error, ProgressListener listener, ConnectionCallback callback) throws BackgroundException {
        Bulk download = source.getFeature(Bulk.class);
        download.post(Transfer.Type.download, files, callback);
        Bulk upload = destination.getFeature(Bulk.class);
        HashMap<TransferItem, TransferStatus> targets = new HashMap<TransferItem, TransferStatus>();
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            targets.put(new TransferItem(this.mapping.get(entry.getKey().remote)), entry.getValue());
        }
        upload.post(Transfer.Type.upload, targets, callback);
    }

    @Override
    public void transfer(Session<?> session, Session<?> destination, Path source, Local n, TransferOptions options, TransferStatus overall, TransferStatus segment, ConnectionCallback connectionCallback, ProgressListener listener, StreamListener streamListener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Transfer file %s with options %s", source, options));
        }
        listener.message(MessageFormat.format(LocaleFactory.localizedString("Copying {0} to {1}", "Status"), source.getName(), this.mapping.get(source).getName()));
        if (source.isDirectory()) {
            if (!segment.isExists()) {
                Directory feature = destination.getFeature(Directory.class);
                feature.mkdir(this.mapping.get(source), segment);
                segment.setComplete();
            }
        } else {
            Copy feature = new DefaultCopyFeature(session).withTarget((Session)destination);
            feature.copy(source, this.mapping.get(source), segment, connectionCallback, new CopyStreamListener(this, streamListener));
        }
    }

    @Override
    public void normalize() {
    }

    private static final class CopyStreamListener
    extends DelegateStreamListener {
        private final CopyTransfer transfer;

        public CopyStreamListener(CopyTransfer transfer, StreamListener delegate) {
            super(delegate);
            this.transfer = transfer;
        }

        @Override
        public void sent(long bytes) {
            this.transfer.addTransferred(bytes);
            super.sent(bytes);
        }
    }
}

