/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferConnectionLimiter;

public class AutoTransferConnectionLimiter
implements TransferConnectionLimiter {
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public int getLimit(Host host) {
        switch (Host.TransferType.getType(host)) {
            case newconnection: {
                return 1;
            }
        }
        if (0 == this.preferences.getInteger("queue.connections.limit")) {
            int limit = this.preferences.getInteger(String.format("queue.connections.limit.%s", host.getProtocol().getType().name()));
            if (-1 == limit) {
                return this.preferences.getInteger("queue.connections.limit.default");
            }
            return limit;
        }
        return this.preferences.getInteger("queue.connections.limit");
    }
}

