/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import ch.cyberduck.core.worker.TransferWorker;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferWorkerBackgroundAction<T>
extends RegistryBackgroundAction<T> {
    private static final Logger log = LogManager.getLogger(TransferWorkerBackgroundAction.class);
    private final SessionPool pool;
    protected final TransferWorker<T> worker;
    protected T result;

    public TransferWorkerBackgroundAction(Controller controller, SessionPool pool, TransferWorker<T> worker) {
        super(controller, pool);
        this.pool = pool;
        this.worker = worker;
    }

    @Override
    protected void reset() throws BackgroundException {
        this.worker.reset();
        super.reset();
    }

    @Override
    public T run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run worker %s", this.worker));
        }
        try {
            this.pool.release(session, null);
            return this.worker.run(session);
        }
        catch (ConnectionCanceledException e) {
            this.worker.cancel();
            throw e;
        }
    }

    @Override
    public void cleanup() {
        if (null == this.result) {
            log.warn(String.format("Missing result for worker %s. Use default value.", this.worker));
            this.worker.cleanup(this.worker.initialize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Cleanup worker %s", this.worker));
            }
            this.worker.cleanup(this.result);
        }
        super.cleanup();
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Cancel worker %s", this.worker));
        }
        this.worker.cancel();
        super.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.worker.isCanceled();
    }

    @Override
    public String getActivity() {
        return this.worker.getActivity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferWorkerBackgroundAction that = (TransferWorkerBackgroundAction)o;
        return Objects.equals(this.worker, that.worker);
    }

    public int hashCode() {
        return Objects.hash(this.worker);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkerBackgroundAction{");
        sb.append("worker=").append(this.worker);
        sb.append('}');
        return sb.toString();
    }
}

