/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SessionBackgroundAction<T>
extends AbstractBackgroundAction<T>
implements ProgressListener,
TranscriptListener {
    private static final Logger log = LogManager.getLogger(SessionBackgroundAction.class);
    private BackgroundException failure;
    private final StringBuffer transcript = new StringBuffer();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final AlertCallback alert;
    private final ProgressListener progress;
    protected final SessionPool pool;

    public SessionBackgroundAction(SessionPool pool, AlertCallback alert, ProgressListener progress) {
        this.pool = pool;
        this.alert = alert;
        this.progress = progress;
    }

    @Override
    public void message(String message) {
        this.progress.message(message);
    }

    @Override
    public void log(TranscriptListener.Type request, String message) {
        this.transcript.append(message).append(LINE_SEPARATOR);
    }

    @Override
    public void prepare() {
        super.prepare();
        this.message(this.getActivity());
    }

    protected void reset() throws BackgroundException {
        this.failure = null;
    }

    public boolean hasFailed() {
        return this.failure != null;
    }

    public BackgroundException getFailure() {
        return this.failure;
    }

    @Override
    public T call() throws BackgroundException {
        try {
            return new DefaultRetryCallable(this.pool.getHost(), new BackgroundExceptionCallable<T>(){

                @Override
                public T call() throws BackgroundException {
                    SessionBackgroundAction.this.reset();
                    return SessionBackgroundAction.this.run();
                }
            }, this, this).call();
        }
        catch (ConnectionCanceledException e) {
            throw e;
        }
        catch (BackgroundException e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public T run() throws BackgroundException {
        Session<?> session = this.pool.borrow(this).withListener(this);
        BackgroundException failure = null;
        try {
            T t = this.run(session);
            return t;
        }
        catch (BackgroundException e) {
            failure = e;
            throw e;
        }
        finally {
            this.pool.release(session.removeListener(this), failure);
        }
    }

    public abstract T run(Session<?> var1) throws BackgroundException;

    @Override
    public boolean alert(BackgroundException failure) {
        if (this.isCanceled()) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Run alert callback %s for failure %s", this.alert, failure));
        }
        return this.alert.alert(this.pool.getHost(), failure, new StringBuilder(this.transcript.toString()));
    }

    @Override
    public void cleanup() {
        this.transcript.setLength(0);
        this.message("");
    }

    @Override
    public String getName() {
        return BookmarkNameProvider.toString(this.pool.getHost());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SessionBackgroundAction{");
        sb.append("failure=").append(this.failure);
        sb.append(", pool=").append(this.pool);
        sb.append('}');
        return sb.toString();
    }
}

