/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledThreadPool {
    private static final Logger log = LogManager.getLogger(ScheduledThreadPool.class);
    private final ScheduledExecutorService pool;

    public ScheduledThreadPool() {
        this(new LoggingUncaughtExceptionHandler());
    }

    public ScheduledThreadPool(Thread.UncaughtExceptionHandler handler) {
        this.pool = Executors.newScheduledThreadPool(1, new NamedThreadFactory("timer", handler));
    }

    public ScheduledFuture<?> repeat(Runnable runnable, Long period, TimeUnit unit) {
        return this.repeat(runnable, 0L, period, unit);
    }

    public ScheduledFuture repeat(Runnable runnable, long delay, Long period, TimeUnit unit) {
        return this.pool.scheduleAtFixedRate(runnable, delay, period, unit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, Long delay, TimeUnit unit) {
        return this.pool.schedule(runnable, (long)delay, unit);
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info(String.format("Shutdown pool %s", this.pool));
        }
        this.pool.shutdown();
    }
}

