/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.DefaultComparePathFilter;
import ch.cyberduck.core.threading.BrowserTransferBackgroundAction;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.CompareFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.DisabledDownloadSymlinkResolver;
import ch.cyberduck.ui.quicklook.QuickLook;
import java.util.ArrayList;
import java.util.List;

public class QuicklookTransferBackgroundAction
extends BrowserTransferBackgroundAction {
    private final QuickLook quicklook;
    private final List<TransferItem> downloads;

    public QuicklookTransferBackgroundAction(final Controller controller, QuickLook quicklook, SessionPool session, List<TransferItem> items) {
        super(controller, session, QuicklookTransferBackgroundAction.toDownload(session, items), new TransferCallback(){

            @Override
            public void complete(Transfer transfer) {
            }
        }, new TransferPrompt(){

            @Override
            public TransferAction prompt(TransferItem item) {
                return TransferAction.comparison;
            }

            @Override
            public boolean isSelected(TransferItem file) {
                return true;
            }

            @Override
            public void message(String message) {
                controller.message(message);
            }
        });
        this.quicklook = quicklook;
        this.downloads = items;
    }

    private static Transfer toDownload(final SessionPool session, List<TransferItem> items) {
        return new DownloadTransfer(session.getHost(), items){

            @Override
            public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) {
                return TransferAction.comparison;
            }

            @Override
            public AbstractDownloadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
                DownloadFilterOptions options = new DownloadFilterOptions(session.getHost());
                options.segments = false;
                return new CompareFilter(new DisabledDownloadSymlinkResolver(), source, options, listener, new DefaultComparePathFilter(source, session.getHost().getTimezone()){

                    @Override
                    public Comparison compare(Path file, Local local, ProgressListener listener) throws BackgroundException {
                        switch (super.compare(file, local, listener)) {
                            case equal: {
                                return Comparison.equal;
                            }
                        }
                        return Comparison.remote;
                    }
                }).withFinder(new Find(){

                    @Override
                    public boolean find(Path file, ListProgressListener listener) {
                        return true;
                    }
                }).withAttributes(new AttributesFinder(){

                    @Override
                    public PathAttributes find(Path file, ListProgressListener listener) {
                        return file.attributes();
                    }
                });
            }
        };
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (!this.hasFailed()) {
            ArrayList<Local> previews = new ArrayList<Local>();
            for (TransferItem download : this.downloads) {
                previews.add(download.local);
            }
            this.quicklook.select(previews);
            this.quicklook.open();
        }
    }

    @Override
    public String getActivity() {
        return LocaleFactory.localizedString("Quick Look", "Status");
    }
}

