/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = LogManager.getLogger(NamedThreadFactory.class);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private final ThreadPool.Priority priority;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String name) {
        this(name, new LoggingUncaughtExceptionHandler());
    }

    public NamedThreadFactory(String name, Thread.UncaughtExceptionHandler handler) {
        this(name, ThreadPool.Priority.norm, handler);
    }

    public NamedThreadFactory(String name, ThreadPool.Priority priority, Thread.UncaughtExceptionHandler handler) {
        this.name = name;
        this.priority = priority;
        this.handler = handler;
    }

    @Override
    public Thread newThread(final Runnable action) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create thread for runnable %s", action));
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                action.run();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Finished execution of runnable %s", action));
                }
            }
        });
        thread.setDaemon(true);
        thread.setName(String.format("%s-%d", this.name, this.threadNumber.getAndIncrement()));
        thread.setPriority(this.priority.toInteger());
        thread.setUncaughtExceptionHandler(this.handler);
        return thread;
    }
}

