/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.ExecutorServiceThreadPool;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ThreadPool;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultThreadPool
extends ExecutorServiceThreadPool {
    public DefaultThreadPool() {
        this(PreferencesFactory.get().getInteger("threading.pool.size.max"));
    }

    public DefaultThreadPool(int size) {
        this("background", size);
    }

    public DefaultThreadPool(String prefix) {
        this(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"));
    }

    public DefaultThreadPool(String prefix, int size) {
        this(prefix, size, new LoggingUncaughtExceptionHandler());
    }

    public DefaultThreadPool(int size, Thread.UncaughtExceptionHandler handler) {
        this("background", size, handler);
    }

    public DefaultThreadPool(String prefix, int size, Thread.UncaughtExceptionHandler handler) {
        this(prefix, size, ThreadPool.Priority.norm, handler);
    }

    public DefaultThreadPool(String prefix, int size, ThreadPool.Priority priority, Thread.UncaughtExceptionHandler handler) {
        this(prefix, size, priority, new LinkedBlockingQueue<Runnable>(size), new CustomCallerPolicy(), handler);
    }

    public DefaultThreadPool(String prefix, int size, ThreadPool.Priority priority, BlockingQueue<Runnable> queue, Thread.UncaughtExceptionHandler handler) {
        this(prefix, size, priority, queue, new CustomCallerPolicy(), handler);
    }

    public DefaultThreadPool(String prefix, int size, ThreadPool.Priority priority, BlockingQueue<Runnable> queue, RejectedExecutionHandler policy, Thread.UncaughtExceptionHandler handler) {
        super(DefaultThreadPool.createExecutor(prefix, size, priority, queue, policy, handler));
    }

    public static ThreadPoolExecutor createExecutor(String prefix, int size, ThreadPool.Priority priority, BlockingQueue<Runnable> queue, RejectedExecutionHandler policy, final Thread.UncaughtExceptionHandler handler) {
        return new ThreadPoolExecutor(size, size, PreferencesFactory.get().getLong("threading.pool.keepalive.seconds"), TimeUnit.SECONDS, queue, new NamedThreadFactory(prefix, priority, handler), policy){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    handler.uncaughtException(Thread.currentThread(), t);
                }
            }
        };
    }

    public static final class CustomCallerPolicy
    extends ThreadPoolExecutor.AbortPolicy {
        private static final Logger log = LogManager.getLogger(CustomCallerPolicy.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                log.warn(String.format("Run %s on caller thread", r));
                r.run();
            } else {
                log.error(String.format("Rejected execution of %s", r));
                super.rejectedExecution(r, e);
            }
        }
    }
}

