/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AbstractRetryCallable;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.TransferBackgroundActionState;

public class DefaultRetryCallable<T>
extends AbstractRetryCallable<T> {
    private final BackgroundExceptionCallable<T> delegate;
    private final ProgressListener listener;
    private final BackgroundActionState cancel;

    public DefaultRetryCallable(Host host, BackgroundExceptionCallable<T> delegate, StreamCancelation status) {
        this(host, delegate, new DisabledProgressListener(), new TransferBackgroundActionState(status));
    }

    public DefaultRetryCallable(Host host, BackgroundExceptionCallable<T> delegate, ProgressListener listener, BackgroundActionState cancel) {
        this(host, PreferencesFactory.get().getInteger("connection.retry"), PreferencesFactory.get().getInteger("connection.retry.delay"), delegate, listener, cancel);
    }

    public DefaultRetryCallable(Host host, int retry, int delay, BackgroundExceptionCallable<T> delegate, ProgressListener listener, BackgroundActionState cancel) {
        super(host, retry, delay);
        this.delegate = delegate;
        this.listener = listener;
        this.cancel = cancel;
    }

    @Override
    public T call() throws BackgroundException {
        while (!this.cancel.isCanceled()) {
            try {
                return this.delegate.call();
            }
            catch (BackgroundException e) {
                if (this.retry(e, this.listener, this.cancel)) continue;
                throw e;
            }
        }
        throw new ConnectionCanceledException();
    }
}

