/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.threading.ActionOperationBatcher;
import ch.cyberduck.core.threading.ActionOperationBatcherFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackgroundCallable<T>
implements Callable<T> {
    private static final Logger log = LogManager.getLogger(BackgroundCallable.class);
    private final BackgroundAction<T> action;
    private final Controller controller;
    private final Exception client = new Exception();

    public BackgroundCallable(BackgroundAction<T> action, Controller controller) {
        this.action = action;
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() {
        T t;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Running background action %s", this.action));
        }
        ActionOperationBatcher autorelease = ActionOperationBatcherFactory.get();
        if (this.action.isCanceled()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Prepare background action %s", this.action));
        }
        this.action.prepare();
        try {
            T result = this.run();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return result %s from background action %s", result, this.action));
            }
            t = result;
            this.action.finish();
        }
        catch (Throwable throwable) {
            this.action.finish();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Invoke cleanup for background action %s", this.action));
            }
            this.controller.invoke(new ControllerMainAction(this.controller){

                @Override
                public void run() {
                    try {
                        BackgroundCallable.this.action.cleanup();
                    }
                    catch (Exception e) {
                        log.error(String.format("Exception %s running cleanup task", e), (Throwable)e);
                    }
                }
            });
            if (log.isDebugEnabled()) {
                log.debug(String.format("Releasing lock for background runnable %s", this.action));
            }
            autorelease.operate();
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Invoke cleanup for background action %s", this.action));
        }
        this.controller.invoke(new /* invalid duplicate definition of identical inner class */);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Releasing lock for background runnable %s", this.action));
        }
        autorelease.operate();
        return t;
    }

    protected T run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Call background action %s", this.action));
            }
            return this.action.call();
        }
        catch (BackgroundException e) {
            this.failure(this.client, e);
            if (this.action.alert(e)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Retry background action %s", this.action));
                }
                return this.run();
            }
            return null;
        }
        catch (Exception e) {
            this.failure(this.client, e);
            if (this.action.alert(new DefaultExceptionMappingService().map(e))) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Retry background action %s", this.action));
                }
                return this.run();
            }
            return null;
        }
    }

    protected void failure(Exception trace, Exception failure) {
        try {
            trace.initCause(failure);
        }
        catch (IllegalStateException e) {
            log.warn(String.format("Failure overwriting cause for failure %s with %s", trace, failure));
        }
        if (failure instanceof UnsupportedException) {
            log.debug(String.format("Failure %s running background task", failure), (Throwable)trace);
        } else {
            log.warn(String.format("Failure %s running background task", failure), (Throwable)trace);
        }
    }
}

