/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBackgroundAction<T>
implements BackgroundAction<T> {
    private static final Logger log = LogManager.getLogger(AbstractBackgroundAction.class);
    private State state;
    protected final Set<BackgroundActionListener> listeners = new CopyOnWriteArraySet<BackgroundActionListener>();

    @Override
    public void init() {
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Cancel background task %s", this));
        }
        Iterator<BackgroundActionListener> iter = this.listeners.iterator();
        for (BackgroundActionListener listener : this.listeners) {
            listener.cancel(this);
        }
        this.state = State.canceled;
    }

    @Override
    public boolean isCanceled() {
        return this.state == State.canceled;
    }

    @Override
    public boolean isRunning() {
        return this.state == State.running;
    }

    @Override
    public void prepare() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Prepare background task %s", this));
        }
        for (BackgroundActionListener listener : this.listeners) {
            listener.start(this);
        }
        this.state = State.running;
    }

    @Override
    public void finish() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Finish background task %s", this));
        }
        for (BackgroundActionListener listener : this.listeners) {
            listener.stop(this);
        }
        this.state = State.stopped;
    }

    @Override
    public boolean alert(BackgroundException e) {
        return false;
    }

    @Override
    public T call() throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run background task %s", this));
        }
        return this.run();
    }

    @Override
    public void cleanup() {
    }

    protected String toString(List<Path> files) {
        StringBuilder name = new StringBuilder();
        name.append(files.get(0).getName());
        if (files.size() > 1) {
            name.append("\u2026");
        }
        return name.toString();
    }

    @Override
    public void addListener(BackgroundActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(BackgroundActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getActivity() {
        return LocaleFactory.localizedString("Unknown");
    }

    @Override
    public String getName() {
        return LocaleFactory.localizedString("Unknown");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractBackgroundAction{");
        sb.append("state=").append((Object)this.state);
        sb.append('}');
        return sb.toString();
    }

    private static enum State {
        running,
        canceled,
        stopped;

    }
}

