/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalAttributes;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.synchronization.ChecksumComparisonService;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonService;
import ch.cyberduck.core.synchronization.SizeComparisonService;
import ch.cyberduck.core.synchronization.TimestampComparisonService;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TimeZone;

public class DefaultComparePathFilter
implements ComparePathFilter {
    private Find finder;
    private AttributesFinder attribute;
    private final ComparisonService checksum;
    private final ComparisonService size;
    private final ComparisonService timestamp;

    public DefaultComparePathFilter(Session<?> session, TimeZone tz) {
        this.finder = session.getFeature(Find.class, new DefaultFindFeature(session));
        this.attribute = session.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(session));
        this.timestamp = new TimestampComparisonService(tz);
        this.size = new SizeComparisonService();
        this.checksum = new ChecksumComparisonService();
    }

    @Override
    public ComparePathFilter withFinder(Find finder) {
        this.finder = finder;
        return this;
    }

    @Override
    public ComparePathFilter withAttributes(AttributesFinder attribute) {
        this.attribute = attribute;
        return this;
    }

    @Override
    public ComparePathFilter withCache(Map<TransferItem, Comparison> cache) {
        return this;
    }

    @Override
    public Comparison compare(Path file, Local local, ProgressListener listener) throws BackgroundException {
        if (local.exists()) {
            if (this.finder.find(file)) {
                if (file.isDirectory()) {
                    return Comparison.equal;
                }
                PathAttributes attributes = this.attribute.find(file);
                LocalAttributes l = local.attributes();
                switch (this.size.compare(attributes, l)) {
                    case remote: {
                        return Comparison.remote;
                    }
                    case local: {
                        return Comparison.local;
                    }
                }
                if (Checksum.NONE != attributes.getChecksum()) {
                    listener.message(MessageFormat.format(LocaleFactory.localizedString("Compute MD5 hash of {0}", "Status"), file.getName()));
                    l.setChecksum(ChecksumComputeFactory.get(attributes.getChecksum().algorithm).compute(local.getInputStream(), new TransferStatus()));
                    switch (this.checksum.compare(attributes, l)) {
                        case equal: {
                            return Comparison.equal;
                        }
                    }
                }
                Comparison compare = this.timestamp.compare(attributes, l);
                switch (compare) {
                    case unknown: {
                        switch (this.size.compare(attributes, l)) {
                            case local: 
                            case notequal: {
                                return Comparison.local;
                            }
                            case remote: {
                                return Comparison.remote;
                            }
                        }
                        return Comparison.equal;
                    }
                }
                return compare;
            }
            return Comparison.local;
        }
        if (this.finder.find(file)) {
            return Comparison.remote;
        }
        return Comparison.equal;
    }
}

