/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.DefaultComparePathFilter;
import ch.cyberduck.core.transfer.TransferItem;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingComparePathFilter
implements ComparePathFilter {
    private static final Logger log = LogManager.getLogger(CachingComparePathFilter.class);
    private Map<TransferItem, Comparison> cache = Collections.emptyMap();
    private final DefaultComparePathFilter delegate;

    public CachingComparePathFilter(DefaultComparePathFilter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Comparison compare(Path file, Local local, ProgressListener listener) throws BackgroundException {
        if (!this.cache.containsKey(new TransferItem(file, local))) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Compare file %s", file));
            }
            this.cache.put(new TransferItem(file, local), this.delegate.compare(file, local, listener));
        }
        Comparison comparison = this.cache.get(new TransferItem(file, local));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return comparison %s for file %s", new Object[]{comparison, file}));
        }
        return comparison;
    }

    public Comparison get(TransferItem item) {
        if (this.cache.containsKey(item)) {
            return this.cache.get(item);
        }
        return Comparison.unknown;
    }

    public void reset() {
        this.cache.clear();
    }

    @Override
    public CachingComparePathFilter withFinder(Find finder) {
        this.delegate.withFinder(finder);
        return this;
    }

    @Override
    public CachingComparePathFilter withAttributes(AttributesFinder attribute) {
        this.delegate.withAttributes(attribute);
        return this;
    }

    @Override
    public CachingComparePathFilter withCache(Map<TransferItem, Comparison> cache) {
        this.cache = cache;
        return this;
    }
}

