/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.ssl.AbstractX509KeyManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultX509KeyManager
extends AbstractX509KeyManager
implements X509KeyManager {
    private static final Logger log = LogManager.getLogger(DefaultX509KeyManager.class);
    private javax.net.ssl.X509KeyManager _manager;

    @Override
    public X509KeyManager init() {
        return this;
    }

    private synchronized javax.net.ssl.X509KeyManager getKeystore() throws IOException {
        try {
            if (null == this._manager) {
                KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
                store.load(null);
                factory.init(store, null);
                for (KeyManager m : factory.getKeyManagers()) {
                    if (!(m instanceof javax.net.ssl.X509KeyManager)) continue;
                    this._manager = (javax.net.ssl.X509KeyManager)m;
                    break;
                }
                if (null == this._manager) {
                    throw new NoSuchAlgorithmException(String.format("The default algorithm %s did not produce a X.509 key manager", KeyManagerFactory.getDefaultAlgorithm()));
                }
            }
            return this._manager;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error(String.format("Initialization of key store failed. %s", e.getMessage()));
            throw new IOException(e);
        }
    }

    @Override
    public X509Certificate getCertificate(String alias, String[] keyTypes, Principal[] issuers) {
        for (X509Certificate cert : this._manager.getCertificateChain(alias)) {
            if (!this.matches(cert, keyTypes, issuers)) continue;
            return cert;
        }
        return null;
    }

    @Override
    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            javax.net.ssl.X509KeyManager manager = this.getKeystore();
            String[] aliases = manager.getClientAliases("RSA", null);
            if (null != aliases) {
                Collections.addAll(list, aliases);
            }
            if (null != (aliases = manager.getClientAliases("DSA", null))) {
                Collections.addAll(list, aliases);
            }
        }
        catch (IOException e) {
            log.warn(String.format("Failure listing aliases. %s", e.getMessage()));
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        javax.net.ssl.X509KeyManager manager;
        try {
            manager = this.getKeystore();
        }
        catch (IOException e) {
            return null;
        }
        return manager.getPrivateKey(alias);
    }
}

