/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.idna.PunycodeConverter;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTrustManagerHostnameCallback
implements TrustManagerHostnameCallback {
    private static final Logger log = LogManager.getLogger(DefaultTrustManagerHostnameCallback.class);
    private final Host host;

    public DefaultTrustManagerHostnameCallback(Host host) {
        this.host = host;
    }

    @Override
    public String getTarget() {
        if (StringUtils.isBlank((CharSequence)this.host.getHostname())) {
            log.error(String.format("Missing hostname to validate in %s", this.host));
        }
        return new PunycodeConverter().convert(this.host.getHostname());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultTrustManagerHostnameCallback{");
        sb.append("host=").append(this.host);
        sb.append('}');
        return sb.toString();
    }
}

