/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.AbstractX509KeyManager;
import java.io.IOException;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStoreX509KeyManager
extends AbstractX509KeyManager {
    private static final Logger log = LogManager.getLogger(CertificateStoreX509KeyManager.class);
    private final CertificateIdentityCallback prompt;
    private final Host bookmark;
    private final CertificateStore callback;
    private KeyStore keystore;

    public CertificateStoreX509KeyManager(CertificateIdentityCallback prompt, Host bookmark, CertificateStore callback) {
        this.prompt = prompt;
        this.bookmark = bookmark;
        this.callback = callback;
    }

    @Override
    public CertificateStoreX509KeyManager init() {
        return this;
    }

    public CertificateStoreX509KeyManager withKeyStore(KeyStore keystore) {
        this.keystore = keystore;
        return this;
    }

    private synchronized KeyStore getKeystore() throws IOException {
        String type = null;
        try {
            if (null == this.keystore) {
                String provider;
                Preferences preferences = PreferencesFactory.get();
                type = preferences.getProperty("connection.ssl.keystore.type");
                if (log.isInfoEnabled()) {
                    log.info(String.format("Load default store of type %s", type));
                }
                if (null == type) {
                    type = KeyStore.getDefaultType();
                }
                this.keystore = StringUtils.isBlank((CharSequence)(provider = preferences.getProperty("connection.ssl.keystore.provider"))) ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                this.keystore.load(null, null);
            }
        }
        catch (Exception e) {
            try {
                log.error(String.format("Could not load default store of type %s", type), (Throwable)e);
                if (log.isInfoEnabled()) {
                    log.info("Load default store of default type");
                }
                this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.keystore.load(null, null);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                log.error(String.format("Initialization of key store failed. %s", e.getMessage()));
                throw new IOException(e);
            }
        }
        return this.keystore;
    }

    @Override
    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            KeyStore store;
            try {
                store = this.getKeystore();
            }
            catch (IOException e) {
                log.warn(String.format("Failure listing aliases. %s", e.getMessage()));
                return Collections.emptyList();
            }
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Alias in Keychain %s", alias));
                }
                if (store.isKeyEntry(alias)) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Found private key for %s", alias));
                    }
                    list.add(alias);
                    continue;
                }
                log.warn(String.format("Missing private key for alias %s", alias));
            }
        }
        catch (KeyStoreException e) {
            log.error(String.format("Keystore not loaded %s", e.getMessage()));
        }
        return list;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getClientAliases(new String[]{keyType}, issuers);
    }

    public String[] getClientAliases(String[] keyTypes, Principal[] issuers) {
        ArrayList<String> list = new ArrayList<String>();
        for (String alias : this.list()) {
            X509Certificate cert = this.getCertificate(alias, keyTypes, issuers);
            if (null == cert) {
                log.warn(String.format("Failed to retrieve certificate for alias %s", alias));
                continue;
            }
            log.info(String.format("Add X509 certificate entry %s to list", cert));
            list.add(alias);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public X509Certificate getCertificate(String alias, String[] keyTypes, Principal[] issuers) {
        try {
            KeyStore store;
            try {
                store = this.getKeystore();
            }
            catch (IOException e) {
                return null;
            }
            Certificate cert = store.getCertificate(alias);
            if (this.matches(cert, keyTypes, issuers)) {
                return (X509Certificate)cert;
            }
            for (Certificate c : store.getCertificateChain(alias)) {
                if (!(c instanceof X509Certificate) || !this.matches(c, keyTypes, issuers)) continue;
                return (X509Certificate)cert;
            }
        }
        catch (KeyStoreException e) {
            log.error(String.format("Keystore not loaded %s", e.getMessage()));
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("No matching certificate found for alias %s and issuers %s", alias, Arrays.toString(issuers)));
        }
        return null;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        try {
            X509Certificate selected;
            String hostname = socket.getInetAddress().getHostName();
            try {
                String alias = this.bookmark.getCredentials().getCertificate();
                if (StringUtils.isNotBlank((CharSequence)alias)) {
                    log.info(String.format("Return saved certificate alias %s for host %s", alias, this.bookmark));
                    return alias;
                }
                selected = this.callback.choose(this.prompt, keyTypes, issuers, this.bookmark);
            }
            catch (ConnectionCanceledException e) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("No certificate selected for socket %s", socket));
                }
                return null;
            }
            if (null == selected) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("No certificate selected for socket %s", socket));
                }
                return null;
            }
            String[] aliases = this.getClientAliases(keyTypes, issuers);
            if (null != aliases) {
                KeyStore store;
                try {
                    store = this.getKeystore();
                }
                catch (IOException e) {
                    return null;
                }
                for (String alias : aliases) {
                    if (!store.getCertificate(alias).equals(selected)) continue;
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Selected certificate alias %s for certificate %s", alias, selected));
                    }
                    this.bookmark.getCredentials().setCertificate(alias);
                    return alias;
                }
            }
            log.warn(String.format("No matching alias found for selected certificate %s", selected));
            return null;
        }
        catch (KeyStoreException e) {
            log.error(String.format("Keystore not loaded %s", e.getMessage()));
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            KeyStore store;
            try {
                store = this.getKeystore();
            }
            catch (IOException e) {
                return null;
            }
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            Certificate[] chain = store.getCertificateChain(alias);
            if (null == chain) {
                log.warn(String.format("No certificate chain for alias %s", alias));
                return null;
            }
            for (Certificate cert : chain) {
                if (!(cert instanceof X509Certificate)) continue;
                result.add((X509Certificate)cert);
            }
            if (result.isEmpty()) {
                log.warn(String.format("No certificate chain for alias %s", alias));
                Certificate cert = store.getCertificate(alias);
                if (null == cert) {
                    return null;
                }
                if (cert instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)cert;
                    result.add(x509);
                }
            }
            return result.toArray(new X509Certificate[result.size()]);
        }
        catch (KeyStoreException e) {
            log.error(String.format("Keystore not loaded %s", e.getMessage()));
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            KeyStore store;
            try {
                store = this.getKeystore();
            }
            catch (IOException e) {
                return null;
            }
            if (store.isKeyEntry(alias)) {
                Key key = store.getKey(alias, "null".toCharArray());
                if (key instanceof PrivateKey) {
                    return (PrivateKey)key;
                }
                log.warn(String.format("Key %s for alias %s is not a private key", key, alias));
            } else {
                log.warn(String.format("Alias %s is not a key entry", alias));
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error(String.format("Keystore not loaded %s", e.getMessage()));
        }
        log.warn(String.format("No private key for alias %s", alias));
        return null;
    }
}

