/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.shared.AbstractHomeFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkdirHomeFeature
extends AbstractHomeFeature {
    private static final Logger log = LogManager.getLogger(WorkdirHomeFeature.class);
    private final Host host;

    public WorkdirHomeFeature(Host host) {
        this.host = host;
    }

    @Override
    public Path find() throws BackgroundException {
        if (this.host.getWorkdir() != null) {
            return new PathDictionary().deserialize(this.host.getWorkdir().serialize(SerializerFactory.get()));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("No workdir set for bookmark %s", this.host));
        }
        return null;
    }
}

