/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Home;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathAttributesHomeFeature
implements Home {
    private static final Logger log = LogManager.getLogger(PathAttributesHomeFeature.class);
    private final Session<?> session;
    private final Home proxy;
    private final AttributesFinder attributes;
    private final PathContainerService container;

    public PathAttributesHomeFeature(Session<?> session, Home proxy, AttributesFinder attributes, PathContainerService container) {
        this.session = session;
        this.proxy = proxy;
        this.attributes = attributes;
        this.container = container;
    }

    @Override
    public Path find() throws BackgroundException {
        Path home = this.proxy.find();
        try {
            return home.withAttributes(this.attributes.find(home)).withType(this.container.isContainer(home) ? EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory) : home.getType());
        }
        catch (NotfoundException e) {
            switch (this.session.getHost().getProtocol().getType()) {
                case ftp: {
                    log.warn(String.format("Failure %s retrieving attributes for %s", e, home));
                    return home;
                }
            }
            throw e;
        }
        catch (AccessDeniedException | InteroperabilityException e) {
            log.warn(String.format("Failure %s retrieving attributes for %s", e, home));
            return home;
        }
    }
}

