/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.CaseSensitivePathPredicate;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ListFilteringFeature {
    private static final Logger log = LogManager.getLogger(ListFilteringFeature.class);
    private final Session<?> session;

    public ListFilteringFeature(Session<?> session) {
        this.session = session;
    }

    protected Path search(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> list = this.session._getFeature(ListService.class).list(file.getParent(), listener);
        Path found = list.find(new ListFilteringPredicate(this.session.getCaseSensitivity(), file));
        if (null == found) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("File %s not found in directory listing", file));
            }
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("Return attributes %s for file %s", found.attributes(), file));
        }
        return found;
    }

    public static final class ListFilteringPredicate
    extends DefaultPathPredicate {
        private final Protocol.Case sensitivity;
        private final Path file;

        public ListFilteringPredicate(Protocol.Case sensitivity, Path file) {
            super(file);
            this.sensitivity = sensitivity;
            this.file = file;
        }

        @Override
        public boolean test(Path f) {
            if (StringUtils.isNotBlank((CharSequence)this.file.attributes().getVersionId()) || StringUtils.isNotBlank((CharSequence)this.file.attributes().getFileId())) {
                return super.test(f);
            }
            if (f.attributes().isDuplicate() || f.attributes().isHidden().booleanValue()) {
                return false;
            }
            switch (this.sensitivity) {
                case sensitive: {
                    return new CaseSensitivePathPredicate(this.file).test(f);
                }
                case insensitive: {
                    return new CaseInsensitivePathPredicate(this.file).test(f);
                }
            }
            return false;
        }
    }
}

