/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTouchFeature<T>
implements Touch<T> {
    private static final Logger log = LogManager.getLogger(DefaultTouchFeature.class);
    protected Write<T> write;

    public DefaultTouchFeature(Write<T> writer) {
        this.write = writer;
    }

    @Override
    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            StatusOutputStream<T> writer = this.write.write(file, status, new DisabledConnectionCallback());
            writer.close();
            if (!PathAttributes.EMPTY.equals(status.getResponse())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Received reply %s for creating file %s", status.getResponse(), file));
                }
                return new Path(file).withAttributes(status.getResponse());
            }
            log.warn(String.format("Missing status from writer %s", new Object[]{writer}));
            return file;
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", e, file);
        }
    }

    @Override
    public DefaultTouchFeature<T> withWriter(Write<T> write) {
        this.write = write;
        return this;
    }
}

