/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;

public class DefaultSearchFeature
implements Search {
    private final Session<?> session;

    public DefaultSearchFeature(Session<?> session) {
        this.session = session;
    }

    @Override
    public AttributedList<Path> search(Path workdir, Filter<Path> filter, ListProgressListener listener) throws BackgroundException {
        return this.session.getFeature(ListService.class).list(workdir, new SearchListProgressListener(filter, listener)).filter(filter);
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    private static final class SearchListProgressListener
    implements ListProgressListener {
        private final Filter<Path> filter;
        private final ListProgressListener delegate;

        public SearchListProgressListener(Filter<Path> filter, ListProgressListener delegate) {
            this.filter = filter;
            this.delegate = delegate;
        }

        @Override
        public void chunk(Path parent, AttributedList<Path> list) throws ConnectionCanceledException {
            this.delegate.chunk(parent, list.filter(this.filter));
        }

        @Override
        public ListProgressListener reset() {
            return this;
        }

        @Override
        public void message(String message) {
            this.delegate.message(message);
        }
    }
}

